/*
 * Decompiled with CFR 0.152.
 */
package pinata;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Collection;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import pinata.PinataException;
import pinata.PinataResponse;
import util.InputStreamRequestBody;
import util.IsIpfs;
import util.RequestSender;
import util.Validator;
import util.querybuilder.PinJobsQueryBuilder;
import util.querybuilder.PinListQueryBuilder;

public class Pinata {
    private String pinataApiKey;
    private String pinataSecretApiKey;
    private static final String BASE_URL = "https://api.pinata.cloud";

    public Pinata(String pinataApiKey, String pinataSecretApiKey) {
        this.pinataApiKey = pinataApiKey;
        this.pinataSecretApiKey = pinataSecretApiKey;
    }

    public Pinata() {
    }

    public PinataResponse pinByHash(String hashToPin) throws PinataException, IOException {
        return this.pinByHash(this.pinataApiKey, this.pinataSecretApiKey, hashToPin, null);
    }

    public PinataResponse pinByHash(String pinataApiKey, String pinataSecretApiKey, String hashToPin) throws PinataException, IOException {
        return this.pinByHash(pinataApiKey, pinataSecretApiKey, hashToPin, null);
    }

    public PinataResponse pinByHash(String hashToPin, JSONObject options) throws PinataException, IOException {
        return this.pinByHash(this.pinataApiKey, this.pinataSecretApiKey, hashToPin, options);
    }

    public PinataResponse pinByHash(String pinataApiKey, String pinataSecretApiKey, String hashToPin, JSONObject options) throws PinataException, IOException {
        Validator.validateApiKeys(pinataApiKey, pinataSecretApiKey);
        String endpoint = "https://api.pinata.cloud/pinning/pinByHash";
        if (StringUtils.isBlank((CharSequence)hashToPin)) {
            throw new PinataException("hashToPin value is required for pinning by hash");
        }
        if (!IsIpfs.isCid(hashToPin)) {
            throw new PinataException("hashToPin value is an invalid IPFS CID");
        }
        JSONObject bodyContent = new JSONObject();
        bodyContent.put("hashToPin", (Object)hashToPin);
        bodyContent.put("pinataOptions", (Object)new JSONObject());
        if (options != null) {
            if (options.has("pinataOptions")) {
                bodyContent.put("pinataOptions", (Object)options.getJSONObject("pinataOptions"));
            }
            if (options.has("pinataMetadata")) {
                Validator.validateMetadata(options.getJSONObject("pinataMetadata"));
                bodyContent.put("pinataMetadata", (Object)options.getJSONObject("pinataMetadata"));
            }
        }
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((String)bodyContent.toString(), (MediaType)mediaType);
        return RequestSender.postOrPutRequest("POST", "https://api.pinata.cloud/pinning/pinByHash", body, pinataApiKey, pinataSecretApiKey);
    }

    public PinataResponse hashMetaData(String ipfsPinHash, JSONObject metadata) throws PinataException, IOException {
        return this.hashMetaData(this.pinataApiKey, this.pinataSecretApiKey, ipfsPinHash, metadata);
    }

    public PinataResponse hashMetaData(String pinataApiKey, String pinataSecretApiKey, String ipfsPinHash, JSONObject metadata) throws PinataException, IOException {
        Validator.validateApiKeys(pinataApiKey, pinataSecretApiKey);
        String endpoint = "https://api.pinata.cloud/pinning/hashMetadata";
        if (StringUtils.isBlank((CharSequence)ipfsPinHash)) {
            throw new PinataException("ipfsPinHash value is required for changing the pin policy of a pin");
        }
        if (!IsIpfs.isCid(ipfsPinHash)) {
            throw new PinataException("hashToPin value is an invalid IPFS CID");
        }
        if (metadata == null || metadata.length() == 0) {
            throw new PinataException("no metadata object provided");
        }
        Validator.validateMetadata(metadata);
        JSONObject bodyContent = new JSONObject();
        bodyContent.put("ipfsPinHash", (Object)ipfsPinHash);
        if (metadata.has("name")) {
            bodyContent.put("name", metadata.get("name"));
        }
        if (metadata.has("keyvalues")) {
            bodyContent.put("keyvalues", metadata.get("keyvalues"));
        }
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((String)bodyContent.toString(), (MediaType)mediaType);
        return RequestSender.postOrPutRequest("PUT", "https://api.pinata.cloud/pinning/hashMetadata", body, pinataApiKey, pinataSecretApiKey);
    }

    public PinataResponse hashPinPolicy(String ipfsPinHash, JSONObject newPinPolicy) throws PinataException, IOException {
        return this.hashPinPolicy(this.pinataApiKey, this.pinataSecretApiKey, ipfsPinHash, newPinPolicy);
    }

    public PinataResponse hashPinPolicy(String pinataApiKey, String pinataSecretApiKey, String ipfsPinHash, JSONObject newPinPolicy) throws PinataException, IOException {
        Validator.validateApiKeys(pinataApiKey, pinataSecretApiKey);
        Validator.validatePinPolicyStructure(newPinPolicy);
        if (StringUtils.isBlank((CharSequence)ipfsPinHash)) {
            throw new PinataException("ipfsPinHash value is required for changing the pin policy of a pin");
        }
        if (!IsIpfs.isCid(ipfsPinHash)) {
            throw new PinataException("hashToPin value is an invalid IPFS CID");
        }
        if (newPinPolicy == null || newPinPolicy.length() == 0) {
            throw new PinataException("newPinPolicy is required for changing the pin policy of a pin");
        }
        String endpoint = "https://api.pinata.cloud/pinning/hashPinPolicy";
        JSONObject bodyContent = new JSONObject();
        bodyContent.put("ipfsPinHash", (Object)ipfsPinHash);
        bodyContent.put("newPinPolicy", (Object)newPinPolicy);
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((String)bodyContent.toString(), (MediaType)mediaType);
        return RequestSender.postOrPutRequest("PUT", endpoint, body, pinataApiKey, pinataSecretApiKey);
    }

    public PinataResponse pinFileToIpfs(File file, JSONObject options) throws PinataException, IOException {
        return this.pinFileToIpfs(this.pinataApiKey, this.pinataSecretApiKey, file, options);
    }

    public PinataResponse pinFileToIpfs(File file) throws PinataException, IOException {
        return this.pinFileToIpfs(this.pinataApiKey, this.pinataSecretApiKey, file, null);
    }

    public PinataResponse pinFileToIpfs(String pinataApiKey, String pinataSecretApiKey, File file) throws PinataException, IOException {
        return this.pinFileToIpfs(pinataApiKey, pinataSecretApiKey, file, null);
    }

    public PinataResponse pinFileToIpfs(String pinataApiKey, String pinataSecretApiKey, File file, JSONObject options) throws PinataException, IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            PinataResponse pinataResponse = this.pinFileToIpfs(pinataApiKey, pinataSecretApiKey, fileInputStream, file.getName(), options);
            return pinataResponse;
        }
    }

    public PinataResponse pinFileToIpfs(InputStream fileInputStream, String filename, JSONObject options) throws PinataException, IOException {
        return this.pinFileToIpfs(this.pinataApiKey, this.pinataSecretApiKey, fileInputStream, filename, options);
    }

    public PinataResponse pinFileToIpfs(InputStream fileInputStream, String filename) throws PinataException, IOException {
        return this.pinFileToIpfs(this.pinataApiKey, this.pinataSecretApiKey, fileInputStream, filename, null);
    }

    public PinataResponse pinFileToIpfs(String pinataApiKey, String pinataSecretApiKey, InputStream fileInputStream, String filename) throws PinataException, IOException {
        return this.pinFileToIpfs(pinataApiKey, pinataSecretApiKey, fileInputStream, filename, null);
    }

    public PinataResponse pinFileToIpfs(String pinataApiKey, String pinataSecretApiKey, InputStream fileInputStream, String filename, JSONObject options) throws PinataException, IOException {
        Validator.validateApiKeys(pinataApiKey, pinataSecretApiKey);
        String endpoint = "https://api.pinata.cloud/pinning/pinFileToIPFS";
        MultipartBody.Builder bodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", filename, InputStreamRequestBody.create(fileInputStream, MediaType.parse((String)"application/octet-stream")));
        if (options != null) {
            this.addOptionsToMultiPartBody(bodyBuilder, options);
        }
        MultipartBody body = bodyBuilder.build();
        return RequestSender.postOrPutRequest("POST", endpoint, (RequestBody)body, pinataApiKey, pinataSecretApiKey);
    }

    public PinataResponse pinJsonToIpfs(JSONObject pinataBody) throws PinataException, IOException {
        return this.pinJsonToIpfs(this.pinataApiKey, this.pinataSecretApiKey, pinataBody, null);
    }

    public PinataResponse pinJsonToIpfs(JSONObject pinataBody, JSONObject options) throws PinataException, IOException {
        return this.pinJsonToIpfs(this.pinataApiKey, this.pinataSecretApiKey, pinataBody, options);
    }

    public PinataResponse pinJsonToIpfs(String pinataApiKey, String pinataSecretApiKey, JSONObject pinataBody) throws PinataException, IOException {
        return this.pinJsonToIpfs(pinataApiKey, pinataSecretApiKey, pinataBody, null);
    }

    public PinataResponse pinJsonToIpfs(String pinataApiKey, String pinataSecretApiKey, JSONObject pinataBody, JSONObject options) throws PinataException, IOException {
        Validator.validateApiKeys(pinataApiKey, pinataSecretApiKey);
        JSONObject bodyContent = pinataBody;
        if (options != null) {
            bodyContent = new JSONObject();
            bodyContent.put("pinataContent", (Object)pinataBody);
            if (options.has("pinataOptions")) {
                bodyContent.put("pinataOptions", (Object)options.getJSONObject("pinataOptions"));
            }
            if (options.has("pinataMetadata")) {
                Validator.validateMetadata(options.getJSONObject("pinataMetadata"));
                bodyContent.put("pinataMetadata", (Object)options.getJSONObject("pinataMetadata"));
            }
        }
        String endpoint = "https://api.pinata.cloud/pinning/pinJSONToIPFS";
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((String)bodyContent.toString(), (MediaType)mediaType);
        return RequestSender.postOrPutRequest("POST", endpoint, body, pinataApiKey, pinataSecretApiKey);
    }

    public PinataResponse unpin(String hashToUnpin) throws PinataException, IOException {
        return this.unpin(this.pinataApiKey, this.pinataSecretApiKey, hashToUnpin);
    }

    public PinataResponse unpin(String pinataApiKey, String pinataSecretApiKey, String hashToUnpin) throws PinataException, IOException {
        Validator.validateApiKeys(pinataApiKey, pinataSecretApiKey);
        if (StringUtils.isBlank((CharSequence)hashToUnpin)) {
            throw new PinataException("hashToUnpin value is required for removing a pin from Pinata");
        }
        if (!IsIpfs.isCid(hashToUnpin)) {
            throw new PinataException(hashToUnpin + " is an invalid IPFS CID");
        }
        String endpoint = "https://api.pinata.cloud/pinning/unpin/" + hashToUnpin;
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((String)"", (MediaType)mediaType);
        return RequestSender.postOrPutRequest("DELETE", endpoint, body, pinataApiKey, pinataSecretApiKey);
    }

    public PinataResponse userPinPolicy(JSONObject newPinPolicy) throws PinataException, IOException {
        return this.userPinPolicy(this.pinataApiKey, this.pinataSecretApiKey, newPinPolicy);
    }

    public PinataResponse userPinPolicy(String pinataApiKey, String pinataSecretApiKey, JSONObject newPinPolicy) throws PinataException, IOException {
        Validator.validateApiKeys(pinataApiKey, pinataSecretApiKey);
        Validator.validatePinPolicyStructure(newPinPolicy);
        String endpoint = "https://api.pinata.cloud/pinning/userPinPolicy";
        JSONObject bodyContent = new JSONObject();
        bodyContent.put("newPinPolicy", (Object)newPinPolicy);
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((String)bodyContent.toString(), (MediaType)mediaType);
        return RequestSender.postOrPutRequest("PUT", endpoint, body, pinataApiKey, pinataSecretApiKey);
    }

    public PinataResponse pinFromFs(String sourcePath) throws PinataException, IOException {
        return this.pinFromFs(this.pinataApiKey, this.pinataSecretApiKey, sourcePath, null);
    }

    public PinataResponse pinFromFs(String pinataApiKey, String pinataSecretApiKey, String sourcePath) throws PinataException, IOException {
        return this.pinFromFs(pinataApiKey, pinataSecretApiKey, sourcePath, null);
    }

    public PinataResponse pinFromFs(String sourcePath, JSONObject options) throws PinataException, IOException {
        return this.pinFromFs(this.pinataApiKey, this.pinataSecretApiKey, sourcePath, options);
    }

    public PinataResponse pinFromFs(String pinataApiKey, String pinataSecretApiKey, String sourcePath, JSONObject options) throws PinataException, IOException {
        Validator.validateApiKeys(pinataApiKey, pinataSecretApiKey);
        String endpoint = "https://api.pinata.cloud/pinning/pinFileToIPFS";
        if (!new File(sourcePath).exists()) {
            throw new PinataException("file does not exist");
        }
        if (Files.isRegularFile(Paths.get(sourcePath, new String[0]), new LinkOption[0])) {
            return this.pinFileToIpfs(pinataApiKey, pinataSecretApiKey, new File(sourcePath), options);
        }
        sourcePath = sourcePath.replace("\\\\", "/");
        String[] splitted = sourcePath.split("/");
        String commonPath = sourcePath.substring(0, sourcePath.length() - splitted[splitted.length - 1].length());
        MultipartBody.Builder bodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        File dir = new File(sourcePath);
        Collection files = FileUtils.listFiles((File)dir, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
        for (File f : files) {
            String relativePath = f.getPath().replace(commonPath, "").replace("\\", "/");
            bodyBuilder.addFormDataPart("file", relativePath, RequestBody.create((File)f, (MediaType)MediaType.parse((String)"application/octet-stream")));
        }
        if (options != null) {
            this.addOptionsToMultiPartBody(bodyBuilder, options);
        }
        MultipartBody body = bodyBuilder.build();
        return RequestSender.postOrPutRequest("POST", "https://api.pinata.cloud/pinning/pinFileToIPFS", (RequestBody)body, pinataApiKey, pinataSecretApiKey);
    }

    public PinataResponse testAuthentication() throws PinataException, IOException {
        return this.testAuthentication(this.pinataApiKey, this.pinataSecretApiKey);
    }

    public PinataResponse testAuthentication(String pinataApiKey, String pinataSecretApiKey) throws PinataException, IOException {
        Validator.validateApiKeys(pinataApiKey, pinataSecretApiKey);
        String endpoint = "https://api.pinata.cloud/data/testAuthentication";
        return RequestSender.getRequest(endpoint, pinataApiKey, pinataSecretApiKey);
    }

    public PinataResponse userPinnedDataTotal() throws PinataException, IOException {
        return this.userPinnedDataTotal(this.pinataApiKey, this.pinataSecretApiKey);
    }

    public PinataResponse userPinnedDataTotal(String pinataApiKey, String pinataSecretApiKey) throws PinataException, IOException {
        Validator.validateApiKeys(pinataApiKey, pinataSecretApiKey);
        String endpoint = "https://api.pinata.cloud/data/userPinnedDataTotal";
        return RequestSender.getRequest(endpoint, pinataApiKey, pinataSecretApiKey);
    }

    public PinataResponse pinList(JSONObject filters) throws PinataException, IOException {
        return this.pinList(this.pinataApiKey, this.pinataSecretApiKey, filters);
    }

    public PinataResponse pinList(String pinataApiKey, String pinataSecretApiKey, JSONObject filters) throws PinataException, IOException {
        Validator.validateApiKeys(pinataApiKey, pinataSecretApiKey);
        String endpoint = "https://api.pinata.cloud/pinning/pinList";
        PinListQueryBuilder queryBuilder = new PinListQueryBuilder();
        endpoint = queryBuilder.buildUrl(endpoint, filters);
        return RequestSender.getRequest(endpoint, pinataApiKey, pinataSecretApiKey);
    }

    public PinataResponse pinJobs(JSONObject filters) throws PinataException, IOException {
        return this.pinJobs(this.pinataApiKey, this.pinataSecretApiKey, filters);
    }

    public PinataResponse pinJobs(String pinataApiKey, String pinataSecretApiKey, JSONObject filters) throws PinataException, IOException {
        Validator.validateApiKeys(pinataApiKey, pinataSecretApiKey);
        String endpoint = "https://api.pinata.cloud/pinning/pinJobs";
        PinJobsQueryBuilder queryBuilder = new PinJobsQueryBuilder();
        endpoint = queryBuilder.buildUrl(endpoint, filters);
        return RequestSender.getRequest(endpoint, pinataApiKey, pinataSecretApiKey);
    }

    private MultipartBody.Builder addOptionsToMultiPartBody(MultipartBody.Builder bodyBuilder, JSONObject options) throws PinataException {
        if (options.has("pinataOptions")) {
            Validator.validatePinataOptions(options.getJSONObject("pinataOptions"));
            bodyBuilder.addFormDataPart("pinataOptions", options.getJSONObject("pinataOptions").toString());
        }
        if (options.has("pinataMetadata")) {
            Validator.validateMetadata(options.getJSONObject("pinataMetadata"));
            bodyBuilder.addFormDataPart("pinataMetadata", options.getJSONObject("pinataMetadata").toString());
        }
        return bodyBuilder;
    }
}

