/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.IOException;
import java.io.InputStream;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

public class InputStreamRequestBody
extends RequestBody {
    private final InputStream inputStream;
    private final MediaType contentType;

    private InputStreamRequestBody(InputStream inputStream, MediaType contentType) {
        this.inputStream = inputStream;
        this.contentType = contentType;
    }

    public static RequestBody create(InputStream inputStream, MediaType contentType) {
        return new InputStreamRequestBody(inputStream, contentType);
    }

    public MediaType contentType() {
        return this.contentType;
    }

    public boolean isOneShot() {
        return true;
    }

    public void writeTo(BufferedSink sink) throws IOException {
        try (Source source = Okio.source((InputStream)this.inputStream);){
            sink.writeAll(source);
        }
    }
}

