/*
 * Decompiled with CFR 0.152.
 */
package io.github.zlika.reproducible;

import io.github.zlika.reproducible.Stripper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

class TextFileStripper
implements Stripper {
    private final List<Predicate<String>> predicates = new ArrayList<Predicate<String>>();

    TextFileStripper() {
    }

    public TextFileStripper addPredicate(Predicate<String> predicate) {
        this.predicates.add(predicate.negate());
        return this;
    }

    @Override
    public void strip(File in, File out) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(out), StandardCharsets.UTF_8));
             BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(in), StandardCharsets.UTF_8));){
            reader.lines().filter(s -> this.predicates.stream().allMatch(p -> p.test(s))).forEach(s -> {
                try {
                    writer.write((String)s);
                    writer.write("\r\n");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
    }
}

