/*
 * Decompiled with CFR 0.152.
 */
package io.github.zlika.reproducible;

import io.github.zlika.reproducible.Stripper;
import io.github.zlika.reproducible.TarBzStripper;
import io.github.zlika.reproducible.TarGzStripper;
import io.github.zlika.reproducible.TarStripper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.LocalDateTime;

final class SmartTarStripper
implements Stripper {
    private final boolean overwrite;
    private final LocalDateTime reproducibleDateTime;

    public SmartTarStripper(boolean overwrite, LocalDateTime reproducibleDateTime) {
        this.overwrite = overwrite;
        this.reproducibleDateTime = reproducibleDateTime;
    }

    @Override
    public void strip(File file, File stripped) throws IOException {
        Stripper stripper = this.findImplementation(file);
        stripper.strip(file, stripped);
        if (this.overwrite) {
            Files.move(stripped.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private Stripper findImplementation(File file) {
        String name = file.getName();
        TarStripper impl = name.endsWith(".tar.gz") ? new TarGzStripper(this.reproducibleDateTime) : (name.endsWith(".tar.bz2") ? new TarBzStripper(this.reproducibleDateTime) : new TarStripper(this.reproducibleDateTime));
        return impl;
    }
}

