/*
 * Decompiled with CFR 0.152.
 */
package io.github.zlika.reproducible;

import java.io.File;
import java.io.IOException;
import java.util.Objects;

final class FileUtils {
    private FileUtils() {
    }

    public static String getNameWithoutExtension(File file) {
        String filename = file.getName();
        int index = filename.lastIndexOf(".");
        return index < 0 ? filename : filename.substring(0, index);
    }

    public static String getFileExtension(File file) {
        String filename = file.getName();
        int index = filename.lastIndexOf(46);
        return index < 0 ? "" : filename.substring(index + 1);
    }

    public static void mkdirs(File folder) throws IOException {
        Objects.requireNonNull(folder);
        if (!folder.exists() && !folder.mkdirs()) {
            throw new IOException("Cannot create folder " + folder);
        }
    }
}

