/*
 * Decompiled with CFR 0.152.
 */
package io.github.zlika.reproducible;

import io.github.zlika.reproducible.FileUtils;
import io.github.zlika.reproducible.Stripper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Comparator;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.CompressorException;

public class ArchiveStripper
implements Stripper {
    private final long timestamp;

    public ArchiveStripper(LocalDateTime reproducibleDateTime) {
        this.timestamp = reproducibleDateTime.atZone(ZoneOffset.UTC).toInstant().toEpochMilli();
    }

    @Override
    public void strip(File in, File out) throws IOException {
        Path tmp = Files.createTempDirectory("tmp-" + in.getName(), new FileAttribute[0]);
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(in));
             BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(out));){
            this.strip(is, os, tmp);
        }
        catch (ArchiveException | CompressorException e) {
            throw new IOException(e);
        }
        finally {
            org.codehaus.plexus.util.FileUtils.deleteDirectory((File)tmp.toFile());
        }
    }

    void strip(InputStream in, OutputStream out, Path tmp) throws IOException, ArchiveException, CompressorException {
        String format = ArchiveStreamFactory.detect((InputStream)in);
        try (ArchiveInputStream ain = ArchiveStreamFactory.DEFAULT.createArchiveInputStream(format, in);
             ArchiveOutputStream aout = ArchiveStreamFactory.DEFAULT.createArchiveOutputStream(format, out);){
            if (aout instanceof TarArchiveOutputStream) {
                ((TarArchiveOutputStream)aout).setLongFileMode(3);
            }
            this.strip(ain, aout, tmp);
        }
    }

    void strip(ArchiveInputStream ain, ArchiveOutputStream aout, Path tmp) throws IOException {
        ArchiveEntry entry;
        ArrayList<ArchiveEntry> sortedNames = new ArrayList<ArchiveEntry>();
        while ((entry = ain.getNextEntry()) != null) {
            sortedNames.add(entry);
            File copyTo = new File(tmp.toFile(), entry.getName());
            this.zipSlipProtection(copyTo, tmp);
            if (entry.isDirectory()) {
                FileUtils.mkdirs(copyTo);
                continue;
            }
            File destParent = copyTo.getParentFile();
            FileUtils.mkdirs(destParent);
            Files.copy((InputStream)ain, copyTo.toPath(), new CopyOption[0]);
        }
        sortedNames.sort(Comparator.comparing(ArchiveEntry::getName));
        for (ArchiveEntry sortedEntry : sortedNames) {
            File copyFrom = new File(tmp.toFile(), sortedEntry.getName());
            if (!sortedEntry.isDirectory()) {
                byte[] fileContent = Files.readAllBytes(copyFrom.toPath());
                if (sortedEntry instanceof TarArchiveEntry) {
                    TarArchiveEntry tarEntry = (TarArchiveEntry)sortedEntry;
                    tarEntry.setSize((long)fileContent.length);
                } else if (sortedEntry instanceof ArArchiveEntry) {
                    ArArchiveEntry arEntry = (ArArchiveEntry)sortedEntry;
                    sortedEntry = new ArArchiveEntry(arEntry.getName(), (long)fileContent.length, arEntry.getUserId(), arEntry.getGroupId(), arEntry.getMode(), arEntry.getLastModified());
                } else if (sortedEntry instanceof CpioArchiveEntry) {
                    CpioArchiveEntry cpioEntry = (CpioArchiveEntry)sortedEntry;
                    cpioEntry.setSize((long)fileContent.length);
                }
                aout.putArchiveEntry(this.filterEntry(sortedEntry));
                aout.write(fileContent);
                aout.closeArchiveEntry();
                continue;
            }
            aout.putArchiveEntry(this.filterEntry(sortedEntry));
            aout.closeArchiveEntry();
        }
    }

    private ArchiveEntry filterEntry(ArchiveEntry entry) {
        if (entry instanceof TarArchiveEntry) {
            TarArchiveEntry tarEntry = (TarArchiveEntry)entry;
            tarEntry.setModTime(this.timestamp);
            tarEntry.setGroupId(0);
            tarEntry.setUserId(0);
            tarEntry.setUserName("");
            tarEntry.setGroupName("");
        } else {
            if (entry instanceof ArArchiveEntry) {
                ArArchiveEntry arEntry = (ArArchiveEntry)entry;
                return new ArArchiveEntry(arEntry.getName(), arEntry.getSize(), 0, 0, arEntry.getMode(), this.timestamp / 1000L);
            }
            if (entry instanceof CpioArchiveEntry) {
                CpioArchiveEntry cpioEntry = (CpioArchiveEntry)entry;
                cpioEntry.setTime(this.timestamp / 1000L);
                cpioEntry.setUID(0L);
                cpioEntry.setGID(0L);
            }
        }
        return entry;
    }

    private void zipSlipProtection(File file, Path extractFolder) throws IOException {
        if (!file.toPath().normalize().startsWith(extractFolder)) {
            throw new IOException("Bad zip entry");
        }
    }
}

