/*
 * Decompiled with CFR 0.152.
 */
package io.github.zlika.reproducible;

import io.github.zlika.reproducible.Stripper;
import io.github.zlika.reproducible.TextFileStripper;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public final class PropertiesFileStripper
implements Stripper {
    private final List<String> propertiesToRemove;

    public PropertiesFileStripper(String ... propertiesToRemove) {
        this.propertiesToRemove = Arrays.asList(propertiesToRemove);
    }

    @Override
    public void strip(File in, File out) throws IOException {
        TextFileStripper stripper = new TextFileStripper();
        stripper.addPredicate(s -> s.startsWith("#"));
        this.propertiesToRemove.forEach(property -> stripper.addPredicate(s -> s.startsWith(property + "=")));
        stripper.strip(in, out);
    }
}

