/*
 * Decompiled with CFR 0.152.
 */
package io.github.zlika.reproducible;

import io.github.zlika.reproducible.JaxbObjectFactoryFixer;
import io.github.zlika.reproducible.LineNumberStripper;
import io.github.zlika.reproducible.LineSeparators;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="strip-jaxb", defaultPhase=LifecyclePhase.PROCESS_SOURCES, threadSafe=true)
public final class StripJaxbMojo
extends AbstractMojo {
    private static final int JAXB_FILE_JAXB_COMMENT_LINE_NUMBER = 1;
    private static final int JAXB_FILE_TIMESTAMP_LINE_NUMBER = 4;
    private static final int JAXB_EPISODE_JAXB_COMMENT_LINE_NUMBER = 4;
    private static final int JAXB_EPISODE_TIMESTAMP_LINE_NUMBER = 7;
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(defaultValue="${project.build.directory}/generated-sources", property="reproducible.generatedDirectory", required=true)
    private File generatedDirectory;
    @Parameter(defaultValue="false", property="reproducible.skip")
    private boolean skip;
    @Parameter(defaultValue="true", property="reproducible.fixJaxbOrder")
    private boolean fixJaxbOrder;
    @Parameter(defaultValue="true", property="reproducible.removeJaxbTimestamps")
    private boolean removeJaxbTimestamps;
    @Parameter(defaultValue="", property="reproducible.matchingCommentText")
    private String matchingCommentText;
    @Parameter(defaultValue="CRLF", property="reproducible.lineSeparator")
    private LineSeparators lineSeparator;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution of goal \"strip-jaxb\"");
        } else {
            this.fix();
        }
    }

    private void fix() throws MojoExecutionException {
        if (!this.generatedDirectory.exists() || !this.generatedDirectory.isDirectory()) {
            return;
        }
        Charset charset = Charset.forName(this.encoding);
        JaxbObjectFactoryFixer objectFactoryFixer = new JaxbObjectFactoryFixer(this.getMatchingCommentTexts(), charset);
        LineNumberStripper jaxbFileDateStripper = new LineNumberStripper(4, this.lineSeparator);
        LineNumberStripper jaxbEpisodeDateStripper = new LineNumberStripper(7, this.lineSeparator);
        File tmpFile = this.createTempFile();
        try {
            Files.walk(this.generatedDirectory.toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(f -> {
                try {
                    List<String> lines = Files.readAllLines(f, charset);
                    boolean isJaxbFile = this.isJaxbFile(lines);
                    boolean isObjectFactoryFile = isJaxbFile && "ObjectFactory.java".equals(f.toFile().getName());
                    boolean isEpisodeFile = this.isEpisodeFile(f.toFile().getName(), lines);
                    if (isObjectFactoryFile || isJaxbFile || isEpisodeFile) {
                        this.getLog().info((CharSequence)("Stripping " + f.toFile().getAbsolutePath()));
                        if (isObjectFactoryFile && this.fixJaxbOrder) {
                            objectFactoryFixer.strip(f.toFile(), tmpFile);
                            Files.move(tmpFile.toPath(), f, StandardCopyOption.REPLACE_EXISTING);
                        }
                        if (isJaxbFile && this.removeJaxbTimestamps) {
                            jaxbFileDateStripper.strip(f.toFile(), tmpFile);
                            Files.move(tmpFile.toPath(), f, StandardCopyOption.REPLACE_EXISTING);
                        }
                        if (isEpisodeFile && this.removeJaxbTimestamps) {
                            jaxbEpisodeDateStripper.strip(f.toFile(), tmpFile);
                            Files.move(tmpFile.toPath(), f, StandardCopyOption.REPLACE_EXISTING);
                        }
                    }
                }
                catch (IOException e) {
                    this.getLog().error((CharSequence)("Error when normalizing " + f.toFile().getAbsolutePath()), (Throwable)e);
                }
            });
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error when visiting " + this.generatedDirectory.getAbsolutePath(), (Exception)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isJaxbFile(List<String> lines) {
        if (lines.size() <= 4) return false;
        if (!lines.get(0).equals("//")) return false;
        if (!this.getMatchingCommentTexts().stream().anyMatch(lines.get(1)::contains)) return false;
        if (!lines.get(4).contains(":")) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isEpisodeFile(String filename, List<String> lines) {
        if (!filename.endsWith(".episode")) return false;
        if (lines.size() <= 7) return false;
        if (!this.getMatchingCommentTexts().stream().anyMatch(lines.get(4)::contains)) return false;
        if (!lines.get(7).contains(":")) return false;
        return true;
    }

    private File createTempFile() throws MojoExecutionException {
        try {
            File out = File.createTempFile("ObjectFactory", null);
            out.deleteOnExit();
            return out;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot create temp file", (Exception)e);
        }
    }

    private List<String> getMatchingCommentTexts() {
        ArrayList matchingCommentTexts = Arrays.stream(XjcGenerator.values()).map(XjcGenerator::getMatchingCommentText).collect(Collectors.toCollection(ArrayList::new));
        if (this.matchingCommentText != null && !this.matchingCommentText.trim().isEmpty()) {
            matchingCommentTexts.add(this.matchingCommentText.trim());
        }
        return matchingCommentTexts;
    }

    static enum XjcGenerator {
        COM_SUN_XML_BIND("JavaTM Architecture for XML Binding (JAXB)"),
        ORG_GLASSFISH_JAXB("Eclipse Implementation of JAXB");

        private final String matchingCommentText;

        private XjcGenerator(String matchingCommentText) {
            this.matchingCommentText = matchingCommentText;
        }

        public String getMatchingCommentText() {
            return this.matchingCommentText;
        }
    }
}

