/*
 * Decompiled with CFR 0.152.
 */
package io.github.zlika.reproducible;

import io.github.zlika.reproducible.CompoundStripper;
import io.github.zlika.reproducible.SortTextFileStripper;
import io.github.zlika.reproducible.Stripper;
import io.github.zlika.reproducible.TextFileStripper;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;

public final class ManifestStripper
implements Stripper {
    private static final Comparator<String> MANIFEST_ENTRY_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            if (o1.startsWith("Manifest-Version") || o2.trim().isEmpty()) {
                return -1;
            }
            if (o2.startsWith("Manifest-Version") || o1.trim().isEmpty()) {
                return 1;
            }
            return o1.compareTo(o2);
        }
    };

    @Override
    public void strip(File in, File out) throws IOException {
        TextFileStripper s1 = new TextFileStripper().addPredicate(s -> s.startsWith("Built-By")).addPredicate(s -> s.startsWith("Created-By")).addPredicate(s -> s.startsWith("Build-Jdk")).addPredicate(s -> s.startsWith("Build-Date")).addPredicate(s -> s.startsWith("Build-Time")).addPredicate(s -> s.startsWith("Bnd-LastModified"));
        SortTextFileStripper s2 = new SortTextFileStripper(MANIFEST_ENTRY_COMPARATOR);
        new CompoundStripper(s1, s2).strip(in, out);
    }
}

