/*
 * Decompiled with CFR 0.152.
 */
package io.github.zlika.reproducible;

import io.github.zlika.reproducible.DefaultZipStripper;
import io.github.zlika.reproducible.FileUtils;
import io.github.zlika.reproducible.SmartTarStripper;
import io.github.zlika.reproducible.Stripper;
import io.github.zlika.reproducible.ZipStripper;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="strip-jar", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST, requiresProject=false, threadSafe=true)
public final class StripJarMojo
extends AbstractMojo {
    private static final String[] ZIP_EXT = new String[]{"zip", "jar", "war", "ear"};
    private static final String TAR_GZ_EXT = "tar.gz";
    private static final String TAR_BZ_EXT = "tar.bz2";
    private static final String TAR_EXT = "tar";
    @Parameter(defaultValue="${project.build.directory}", property="reproducible.outputDirectory", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="true", property="reproducible.overwrite")
    private boolean overwrite;
    @Parameter(defaultValue="false", property="reproducible.skip")
    private boolean skip;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution of goal \"strip-jar\"");
        } else {
            this.process(this.findZipFiles(this.outputDirectory), new DefaultZipStripper(new ZipStripper(), this.overwrite));
            this.process(this.findTarFiles(this.outputDirectory), new SmartTarStripper(this.overwrite));
            this.process(this.findTarBzFiles(this.outputDirectory), new SmartTarStripper(this.overwrite));
            this.process(this.findTarGzFiles(this.outputDirectory), new SmartTarStripper(this.overwrite));
        }
    }

    private void process(File[] files, Stripper stripper) throws MojoExecutionException {
        for (File file : files) {
            this.getLog().info((CharSequence)("Stripping " + file.getAbsolutePath()));
            try {
                stripper.strip(file, this.createStrippedFilename(file));
            }
            catch (IOException ioe) {
                throw new MojoExecutionException(String.format("Error stripping file %s:", file.getAbsolutePath()), (Exception)ioe);
            }
        }
    }

    private File[] findZipFiles(File folder) {
        File[] zipFiles = folder.listFiles((dir, name) -> Arrays.stream(ZIP_EXT).anyMatch(ext -> name.toLowerCase().endsWith("." + ext)) && new File(dir, name).isFile());
        return zipFiles != null ? zipFiles : new File[]{};
    }

    private File[] findTarBzFiles(File folder) {
        File[] tbzFiles = folder.listFiles((dir, name) -> name.toLowerCase().endsWith(TAR_BZ_EXT));
        return tbzFiles != null ? tbzFiles : new File[]{};
    }

    private File[] findTarGzFiles(File folder) {
        File[] tgzFiles = folder.listFiles((dir, name) -> name.toLowerCase().endsWith(TAR_GZ_EXT));
        return tgzFiles != null ? tgzFiles : new File[]{};
    }

    private File[] findTarFiles(File folder) {
        File[] tarFiles = folder.listFiles((dir, name) -> name.toLowerCase().endsWith(TAR_EXT));
        return tarFiles != null ? tarFiles : new File[]{};
    }

    private File createStrippedFilename(File originalFile) {
        String filenameWithoutExt = FileUtils.getNameWithoutExtension(originalFile);
        String ext = FileUtils.getFileExtension(originalFile);
        return new File(originalFile.getParentFile(), filenameWithoutExt + "-stripped" + (ext.isEmpty() ? "" : ".") + ext);
    }
}

