/*
 * Decompiled with CFR 0.152.
 */
package io.github.zlika.reproducible;

import io.github.zlika.reproducible.Stripper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileTime;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.X5455_ExtendedTimestamp;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipExtraField;
import org.apache.commons.compress.archivers.zip.ZipFile;

public final class ZipStripper
implements Stripper {
    private static final long DEFAULT_ZIP_TIMESTAMP = LocalDateTime.of(2000, 1, 1, 0, 0, 0, 0).atZone(ZoneOffset.systemDefault()).toInstant().toEpochMilli();
    private final Map<String, Stripper> subFilters = new HashMap<String, Stripper>();

    public ZipStripper addFileStripper(String filename, Stripper stripper) {
        this.subFilters.put(filename, stripper);
        return this;
    }

    @Override
    public void strip(File in, File out) throws IOException {
        try (ZipFile zip = new ZipFile(in);
             ZipArchiveOutputStream zout = new ZipArchiveOutputStream(out);){
            List<String> sortedNames = this.sortEntriesByName(zip.getEntries());
            for (String name : sortedNames) {
                ZipArchiveEntry entry = zip.getEntry(name);
                ZipArchiveEntry strippedEntry = this.filterZipEntry(entry);
                Stripper stripper = this.getSubFilter(name);
                if (stripper != null) {
                    File tmp = File.createTempFile("tmp", null);
                    tmp.deleteOnExit();
                    Files.copy(zip.getInputStream(entry), tmp.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    File tmp2 = File.createTempFile("tmp", null);
                    tmp2.deleteOnExit();
                    stripper.strip(tmp, tmp2);
                    byte[] fileContent = Files.readAllBytes(tmp2.toPath());
                    strippedEntry.setSize((long)fileContent.length);
                    zout.putArchiveEntry((ArchiveEntry)strippedEntry);
                    zout.write(fileContent);
                    zout.closeArchiveEntry();
                    continue;
                }
                zout.addRawArchiveEntry(strippedEntry, zip.getRawInputStream(entry));
            }
        }
    }

    private Stripper getSubFilter(String name) {
        for (Map.Entry<String, Stripper> filter : this.subFilters.entrySet()) {
            if (!name.matches(filter.getKey())) continue;
            return filter.getValue();
        }
        return null;
    }

    private List<String> sortEntriesByName(Enumeration<ZipArchiveEntry> entries) {
        return Collections.list(entries).stream().map(e -> e.getName()).sorted().collect(Collectors.toList());
    }

    private ZipArchiveEntry filterZipEntry(ZipArchiveEntry entry) {
        entry.setCreationTime(FileTime.fromMillis(DEFAULT_ZIP_TIMESTAMP));
        entry.setLastAccessTime(FileTime.fromMillis(DEFAULT_ZIP_TIMESTAMP));
        entry.setLastModifiedTime(FileTime.fromMillis(DEFAULT_ZIP_TIMESTAMP));
        entry.setTime(DEFAULT_ZIP_TIMESTAMP);
        for (ZipExtraField field : entry.getExtraFields()) {
            if (!(field instanceof X5455_ExtendedTimestamp)) continue;
            entry.removeExtraField(field.getHeaderId());
        }
        return entry;
    }
}

