/*
 * Decompiled with CFR 0.152.
 */
package com.didiglobal.logi.job.rest;

import com.didiglobal.logi.job.common.PagingResult;
import com.didiglobal.logi.job.common.Result;
import com.didiglobal.logi.job.common.domain.LogITask;
import com.didiglobal.logi.job.common.dto.TaskPageQueryDTO;
import com.didiglobal.logi.job.common.vo.LogITaskVO;
import com.didiglobal.logi.job.core.consensual.ConsensualEnum;
import com.didiglobal.logi.job.core.task.TaskManager;
import com.didiglobal.logi.job.utils.BeanUtil;
import io.swagger.annotations.Api;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"v1/logi-job/task"})
@Api(tags={"logi-job \u914d\u7f6e\u7684 task \u76f8\u5173\u63a5\u53e3"})
public class TaskController {
    @Autowired
    private TaskManager taskManager;

    @PostMapping(value={"/{taskCode}/do"})
    public Result<Boolean> execute(@PathVariable String taskCode) {
        return this.taskManager.execute(taskCode, (Boolean)false);
    }

    @PostMapping(value={"/list"})
    public PagingResult<LogITaskVO> getAll(@RequestBody TaskPageQueryDTO taskPageQueryDTO) {
        List<LogITask> logITasks = this.taskManager.getPagineList(taskPageQueryDTO);
        int count = this.taskManager.pagineTaskConut(taskPageQueryDTO);
        return PagingResult.buildSucc(this.logITask2LogITaskVO(logITasks), count, taskPageQueryDTO.getPage().intValue(), taskPageQueryDTO.getSize().intValue());
    }

    @PostMapping(value={"/{taskCode}/{status}"})
    public Result<Boolean> status(@PathVariable String taskCode, @PathVariable Integer status) {
        return this.taskManager.updateTaskStatus(taskCode, status);
    }

    @GetMapping(value={"/{taskCode}/detail"})
    public Result<LogITaskVO> detail(@PathVariable String taskCode) {
        return Result.buildSucc(this.logITask2LogITaskVO(this.taskManager.getByCode(taskCode)));
    }

    @PostMapping(value={"/{taskCode}/{workerCode}/release"})
    public Result<Boolean> release(@PathVariable String taskCode, @PathVariable String workerCode) {
        return this.taskManager.release(taskCode, workerCode);
    }

    @DeleteMapping(value={"/{taskCode}"})
    public Result<Boolean> delete(@PathVariable String taskCode) {
        return this.taskManager.delete(taskCode);
    }

    private List<LogITaskVO> logITask2LogITaskVO(List<LogITask> logITasks) {
        if (CollectionUtils.isEmpty(logITasks)) {
            return new ArrayList<LogITaskVO>();
        }
        return logITasks.stream().map(l -> this.logITask2LogITaskVO((LogITask)l)).collect(Collectors.toList());
    }

    private LogITaskVO logITask2LogITaskVO(LogITask logITask) {
        LogITaskVO logITaskVO = BeanUtil.convertTo(logITask, LogITaskVO.class);
        if (!CollectionUtils.isEmpty(logITask.getTaskWorkers())) {
            List<String> ips = logITask.getTaskWorkers().stream().map(w -> w.getIp()).collect(Collectors.toList());
            logITaskVO.setRouting(ConsensualEnum.getByName(logITask.getConsensual()).getDesc());
            logITaskVO.setWorkerIps(ips);
        }
        return logITaskVO;
    }
}

