/*
 * Decompiled with CFR 0.152.
 */
package com.didiglobal.logi.log;

import com.didiglobal.logi.log.ILog;
import com.didiglobal.logi.log.LogException;
import com.didiglobal.logi.log.common.TraceContext;
import com.didiglobal.logi.log.facade.Slf4jFacade;
import com.didiglobal.logi.log.util.FlagGenerator;
import java.lang.reflect.Constructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogFactory.class);
    private static Constructor<? extends ILog> logConstructor;
    private static ThreadLocal<String> flag;
    private static ThreadLocal<TraceContext> trace;

    private static synchronized void useSlf4jLogging() throws Exception {
        Class<Slf4jFacade> clazz = Slf4jFacade.class;
        try {
            logConstructor = clazz.getConstructor(String.class);
            LOGGER.info("Logging initialized using '" + clazz + "' adapter.");
        }
        catch (Throwable t) {
            LOGGER.error("Error setting Log implementation.  Cause: " + t, t);
            throw new LogException("Error setting Log implementation.  Cause: " + t, t);
        }
    }

    private LogFactory() {
    }

    public static ILog getLog(Class<?> aClass) {
        return LogFactory.getLog(aClass.getName());
    }

    public static ILog getLog(String logger) {
        try {
            return logConstructor.newInstance(logger);
        }
        catch (Exception e) {
            LOGGER.error("Error creating logger for logger " + logger + ".  Cause: " + e, (Throwable)e);
            throw new LogException("Error creating logger for logger " + logger + ".  Cause: " + e, e);
        }
    }

    public static void setFlag(String value) {
        flag.set(value);
    }

    public static void setTrace(TraceContext traceContext) {
        trace.set(traceContext);
    }

    public static void setUniqueFlag() {
        flag.set(LogFactory.getUniqueFlag());
    }

    public static String getFlag() {
        return flag.get();
    }

    public static TraceContext getTrace() {
        return trace.get();
    }

    public static void removeFlag() {
        flag.remove();
    }

    public static String getUniqueFlag() {
        return FlagGenerator.get().toStringBabble();
    }

    static {
        flag = new ThreadLocal();
        trace = new ThreadLocal();
        try {
            LogFactory.useSlf4jLogging();
        }
        catch (Throwable t) {
            throw new LogException(t);
        }
    }
}

