/*
 * Decompiled with CFR 0.152.
 */
package com.didiglobal.logi.log;

import com.alibaba.fastjson.JSON;
import com.didiglobal.logi.log.GatherLogSinkRegistry;
import com.didiglobal.logi.log.ILog;
import com.didiglobal.logi.log.LogFactory;
import com.didiglobal.logi.log.LogMetrics;
import com.didiglobal.logi.log.util.HostUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class LogGather {
    private static final ILog LOGGER = LogFactory.getLog(LogGather.class);
    private static final ILog INFO_LOGGER = LogFactory.getLog("gatherInfoLogger");
    private static final ILog WARN_LOGGER = LogFactory.getLog("gatherWarnLogger");
    private static final ILog ERROR_LOGGER = LogFactory.getLog("gatherErrorLogger");
    private static final ILog METRICS_LOGGER = LogFactory.getLog("gatherMetricsLogger");
    private static final ConcurrentMap<String, LogDetail> WARN_LOGS = new ConcurrentHashMap<String, LogDetail>();
    private static final ConcurrentMap<String, LogDetail> ERROR_LOGS = new ConcurrentHashMap<String, LogDetail>();
    private static final ConcurrentMap<String, LogDetail> INFO_LOGS = new ConcurrentHashMap<String, LogDetail>();
    private static final ConcurrentMap<String, MetricsLog> METRICS_LOGS = new ConcurrentHashMap<String, MetricsLog>();
    private static final ConcurrentMap<String, LogMetricsObj> LOG_OBJECT_METRICS = new ConcurrentHashMap<String, LogMetricsObj>();
    private static final ScheduledExecutorService LOG_SCHEDULE = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "LogGather-schedule-pool");
        }
    });

    public static void recordWarnLog(String logCode, String logMsg, Throwable e) {
        LogDetail detail = LogGather.record(WARN_LOGS, logCode, logMsg, e);
        if (detail != null && WARN_LOGGER.isWarnEnabled()) {
            String slog = detail.toString();
            GatherLogSinkRegistry.warnTrigger(slog);
            if (e != null) {
                WARN_LOGGER.warn(slog, e);
            } else {
                WARN_LOGGER.warn(slog);
            }
        }
    }

    public static void recordWarnLog(String logCode, String logMsg) {
        LogGather.recordWarnLog(logCode, logMsg, null);
    }

    public static void recordMetrics(String logCode, Map<String, Object> msgMap) {
        boolean first = false;
        MetricsLog metricsLog = (MetricsLog)METRICS_LOGS.get(logCode);
        if (metricsLog == null) {
            metricsLog = new MetricsLog(logCode, msgMap);
            MetricsLog oLog = METRICS_LOGS.putIfAbsent(logCode, metricsLog);
            if (oLog != null) {
                oLog.incCount();
            } else {
                first = true;
            }
        } else {
            metricsLog.incCount();
        }
        if (first) {
            String slog = metricsLog.toString();
            GatherLogSinkRegistry.metricsTrigger(slog);
            METRICS_LOGGER.info(slog);
        }
    }

    public static void recordObjectMetrics(String logCode, LogMetrics logMetrics) {
        boolean first = false;
        LogMetricsObj logMetricsObj = (LogMetricsObj)LOG_OBJECT_METRICS.get(logCode);
        if (logMetricsObj == null) {
            logMetricsObj = new LogMetricsObj(logCode, logMetrics);
            LogMetricsObj oLogMetricsObj = LOG_OBJECT_METRICS.putIfAbsent(logCode, logMetricsObj);
            if (oLogMetricsObj != null) {
                oLogMetricsObj.incCount();
            } else {
                first = true;
            }
        } else {
            logMetricsObj.incCount();
        }
        if (first) {
            String slog = logMetricsObj.toString();
            GatherLogSinkRegistry.metricsTrigger(slog);
            METRICS_LOGGER.info(slog);
        }
    }

    public static void recordErrorLog(String logCode, String logMsg, Exception e) {
        LogGather.recordErrorLog(logCode, logMsg, (Throwable)e);
    }

    public static void recordErrorLog(String logCode, String logMsg, Throwable e) {
        LogDetail detail = LogGather.record(ERROR_LOGS, logCode, logMsg, e);
        if (detail != null && ERROR_LOGGER.isErrorEnabled()) {
            String slog = detail.toString();
            GatherLogSinkRegistry.errorTrigger(slog);
            if (e != null) {
                ERROR_LOGGER.error(slog, e);
            } else {
                ERROR_LOGGER.error(slog);
            }
        }
    }

    public static void recordErrorLog(String logCode, String logMsg) {
        LogGather.recordErrorLog(logCode, logMsg, null);
    }

    public static void recordInfoLog(String logCode, String logMsg) {
        LogDetail detail = LogGather.record(INFO_LOGS, logCode, logMsg, null);
        if (detail != null && INFO_LOGGER.isInfoEnabled()) {
            String slog = detail.toString();
            GatherLogSinkRegistry.infoTrigger(slog);
            INFO_LOGGER.info(slog);
        }
    }

    private static LogDetail record(ConcurrentMap<String, LogDetail> detailMap, String logCode, String logMsg, Throwable e) {
        boolean first = false;
        LogDetail detail = (LogDetail)detailMap.get(logCode);
        if (detail == null) {
            detail = new LogDetail(logCode, logMsg, e);
            LogDetail oDetail = detailMap.putIfAbsent(logCode, detail);
            if (oDetail != null) {
                oDetail.incCount();
            } else {
                first = true;
            }
        } else {
            detail.incCount();
        }
        if (first) {
            return detail;
        }
        return null;
    }

    static {
        LOG_SCHEDULE.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    ConcurrentHashMap tempErrorLogs = new ConcurrentHashMap();
                    tempErrorLogs.putAll(ERROR_LOGS);
                    ERROR_LOGS.clear();
                    for (Object log : tempErrorLogs.values()) {
                        try {
                            if (((LogDetail)log).restrain()) continue;
                            String slog = ((LogDetail)log).toString();
                            if (ERROR_LOGGER.isErrorEnabled()) {
                                ERROR_LOGGER.error(slog);
                            }
                            GatherLogSinkRegistry.errorTrigger(slog);
                        }
                        catch (Exception e) {
                            LOGGER.error("WriteLogTask runs failed", e);
                        }
                    }
                    ConcurrentHashMap tempWarnLogs = new ConcurrentHashMap();
                    tempWarnLogs.putAll(WARN_LOGS);
                    WARN_LOGS.clear();
                    for (Object log : tempWarnLogs.values()) {
                        try {
                            if (((LogDetail)log).restrain()) continue;
                            String slog = ((LogDetail)log).toString();
                            if (WARN_LOGGER.isWarnEnabled()) {
                                WARN_LOGGER.warn(slog);
                            }
                            GatherLogSinkRegistry.warnTrigger(slog);
                        }
                        catch (Exception e) {
                            LOGGER.error("WriteLogTask runs failed", e);
                        }
                    }
                    ConcurrentHashMap tempInfoLogs = new ConcurrentHashMap();
                    tempInfoLogs.putAll(INFO_LOGS);
                    INFO_LOGS.clear();
                    for (Object log : tempInfoLogs.values()) {
                        try {
                            if (((LogDetail)log).restrain()) continue;
                            String slog = ((LogDetail)log).toString();
                            if (INFO_LOGGER.isInfoEnabled()) {
                                INFO_LOGGER.info(slog);
                            }
                            GatherLogSinkRegistry.infoTrigger(slog);
                        }
                        catch (Exception e) {
                            LOGGER.error("WriteLogTask runs failed", e);
                        }
                    }
                    ConcurrentHashMap tempMetricsLogs = new ConcurrentHashMap();
                    tempMetricsLogs.putAll(METRICS_LOGS);
                    METRICS_LOGS.clear();
                    for (MetricsLog log : tempMetricsLogs.values()) {
                        try {
                            if (log.restrain()) continue;
                            String slog = log.toString();
                            if (METRICS_LOGGER.isInfoEnabled()) {
                                METRICS_LOGGER.info(slog);
                            }
                            GatherLogSinkRegistry.metricsTrigger(slog);
                        }
                        catch (Exception e) {
                            LOGGER.error("WriteLogTask runs failed", e);
                        }
                    }
                    ConcurrentHashMap tempLogObjectMetrics = new ConcurrentHashMap();
                    tempLogObjectMetrics.putAll(LOG_OBJECT_METRICS);
                    LOG_OBJECT_METRICS.clear();
                    for (LogMetricsObj logMetricsObj : tempLogObjectMetrics.values()) {
                        try {
                            if (logMetricsObj.restrain()) continue;
                            String slog = logMetricsObj.toString();
                            if (METRICS_LOGGER.isInfoEnabled()) {
                                METRICS_LOGGER.info(slog);
                            }
                            GatherLogSinkRegistry.metricsTrigger(slog);
                        }
                        catch (Exception e) {
                            LOGGER.error("WriteLogTask runs failed", e);
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error("WriteLogTask runs failed", e);
                }
            }
        }, 1L, 1L, TimeUnit.MINUTES);
    }

    private static class MetricsLog {
        private final String logCode;
        private final AtomicInteger logCount;
        private final Map<String, Object> msgMap;
        private final String flag;

        public MetricsLog(String logCode, Map<String, Object> msgMap) {
            this.logCode = logCode;
            this.msgMap = msgMap;
            this.logCount = new AtomicInteger(1);
            this.flag = LogFactory.getFlag() != null ? LogFactory.getFlag() : LogFactory.getUniqueFlag();
        }

        boolean restrain() {
            return this.logCount.get() == 1;
        }

        public int getLogCount() {
            return this.logCount.get();
        }

        public String getLogCode() {
            return this.logCode;
        }

        public Map<String, Object> getMsgMap() {
            return this.msgMap;
        }

        public void incCount() {
            this.logCount.getAndIncrement();
        }

        public void incCount(int delta) {
            this.logCount.getAndAdd(delta);
        }

        public String toString() {
            HashMap<String, Object> tempMsgMap = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : this.msgMap.entrySet()) {
                if (entry.getValue() instanceof Throwable) {
                    tempMsgMap.put(entry.getKey(), JSON.toJSONString((Object)entry.getValue()));
                    continue;
                }
                tempMsgMap.put(entry.getKey(), entry.getValue());
            }
            tempMsgMap.put("_logCode", this.logCode);
            tempMsgMap.put("_logCount", this.logCount);
            tempMsgMap.put("_logTime", System.currentTimeMillis());
            tempMsgMap.put("_logHost", HostUtil.getHostName());
            tempMsgMap.put("_flag", this.flag);
            return JSON.toJSONString(tempMsgMap);
        }
    }

    private static class LogMetricsObj {
        private final String logCode;
        private final AtomicInteger logCount;
        private final LogMetrics logMetrics;
        private final String flag;

        public LogMetricsObj(String logCode, LogMetrics logMetrics) {
            this.logCode = logCode;
            this.logMetrics = logMetrics;
            this.logCount = new AtomicInteger(1);
            this.flag = LogFactory.getFlag() != null ? LogFactory.getFlag() : LogFactory.getUniqueFlag();
        }

        boolean restrain() {
            return this.logCount.get() == 1;
        }

        public int getLogCount() {
            return this.logCount.get();
        }

        public String getLogCode() {
            return this.logCode;
        }

        public Map<String, Object> getMsgMap() {
            return this.logMetrics.asMap();
        }

        public void incCount() {
            this.logCount.getAndIncrement();
        }

        public void incCount(int delta) {
            this.logCount.getAndAdd(delta);
        }

        public String toString() {
            HashMap<String, Object> tempMsgMap = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : this.getMsgMap().entrySet()) {
                if (entry.getValue() instanceof Throwable) {
                    tempMsgMap.put(entry.getKey(), JSON.toJSONString((Object)entry.getValue()));
                    continue;
                }
                tempMsgMap.put(entry.getKey(), entry.getValue());
            }
            tempMsgMap.put("_logCode", this.logCode);
            tempMsgMap.put("_logCount", this.logCount);
            tempMsgMap.put("_logTime", System.currentTimeMillis());
            tempMsgMap.put("_logHost", HostUtil.getHostName());
            tempMsgMap.put("_flag", this.flag);
            return JSON.toJSONString(tempMsgMap);
        }
    }

    private static class LogDetail {
        private final String logCode;
        private final AtomicInteger count;
        private final String logMsg;
        private final Throwable throwable;

        boolean restrain() {
            return this.count.get() == 1;
        }

        public int getCount() {
            return this.count.get();
        }

        public String getLogCode() {
            return this.logCode;
        }

        public String getLogMsg() {
            return this.logMsg;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public LogDetail(String logCode, String logMsg, Throwable throwable) {
            this.logCode = logCode;
            this.logMsg = logMsg;
            this.throwable = throwable;
            this.count = new AtomicInteger(1);
        }

        public void incCount() {
            this.count.getAndIncrement();
        }

        public void incCount(int delta) {
            this.count.getAndAdd(delta);
        }

        public String toString() {
            HashMap<String, Object> tempMsgMap = new HashMap<String, Object>();
            tempMsgMap.put("logCode", this.logCode);
            tempMsgMap.put("count", this.count);
            tempMsgMap.put("logMsg", this.logMsg);
            tempMsgMap.put("throwable", JSON.toJSONString((Object)this.throwable));
            return JSON.toJSONString(tempMsgMap);
        }
    }
}

