/*
 * Decompiled with CFR 0.152.
 */
package com.didiglobal.logi.log.common;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class URLHelper {
    public static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (StringUtils.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (StringUtils.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (StringUtils.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return URLHelper.fixIp(ip);
    }

    private static String fixIp(String ip) {
        String realIp = ip;
        if (StringUtils.isNotBlank((CharSequence)ip) && ip.contains(",")) {
            String[] ipArray = ip.split(",");
            realIp = ipArray[ipArray.length - 1];
        }
        return realIp != null ? realIp.trim() : null;
    }

    public static void main(String[] args) {
        System.out.println(URLHelper.fixIp("123.123.123.123,321,192.121.121.121"));
    }
}

