/*
 * Decompiled with CFR 0.152.
 */
package com.didiglobal.logi.log.common.web.filter;

import com.didiglobal.logi.log.ILog;
import com.didiglobal.logi.log.LogFactory;
import com.didiglobal.logi.log.common.URLHelper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class AccessLogFilter
implements Filter {
    private static final ILog LOGGER = LogFactory.getLog("accessLogger");

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        long begin = System.currentTimeMillis();
        Map<String, String> params = null;
        try {
            HttpServletRequest request = (HttpServletRequest)req;
            String flag = request.getHeader("flag");
            if (flag == null) {
                flag = request.getHeader("X-Request-ID");
            }
            if (flag == null) {
                flag = LogFactory.getUniqueFlag();
            }
            LogFactory.setFlag(flag);
            params = this.getRequestParams(request);
            LOGGER.info("beforeRequest||params={}", (Object)params);
            chain.doFilter(req, response);
        }
        finally {
            LOGGER.info("afterRequest||params={}||timeCost={}ms", (Object)params, (Object)(System.currentTimeMillis() - begin));
            LogFactory.removeFlag();
        }
    }

    protected Map<String, String> getRequestParams(HttpServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        StringBuilder requestUrl = new StringBuilder(request.getRequestURI());
        if (StringUtils.isNotEmpty((CharSequence)request.getQueryString())) {
            requestUrl.append("?").append(request.getQueryString());
        }
        params.put("requestUrl", requestUrl.toString());
        params.put("method", request.getMethod());
        params.put("host", URLHelper.getIpAddr(request));
        params.put("refer", request.getHeader("referer"));
        params.put("agent", request.getHeader("User-Agent"));
        return params;
    }

    public void destroy() {
    }
}

