/*
 * Decompiled with CFR 0.152.
 */
package com.didiglobal.logi.log.common.web.filter;

import com.didiglobal.logi.log.common.web.filter.TranslateServletInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

class TranslateHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private String body;
    private String encoding = "UTF-8";

    public TranslateHttpServletRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        if (StringUtils.isNotBlank((CharSequence)request.getCharacterEncoding())) {
            this.encoding = request.getCharacterEncoding();
        }
        this.body = IOUtils.toString((InputStream)request.getInputStream(), (String)this.encoding);
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public String getParameter(String name) {
        return super.getParameter(name);
    }

    public String[] getParameterValues(String name) {
        return super.getParameterValues(name);
    }

    public Map getParameterMap() {
        return (HashMap)super.getParameterMap();
    }

    public ServletInputStream getInputStream() throws IOException {
        TranslateServletInputStream inputStream = StringUtils.isNotEmpty((CharSequence)this.body) ? new TranslateServletInputStream(this.body.getBytes(this.encoding)) : new TranslateServletInputStream(new byte[0]);
        return inputStream;
    }

    public String getHeader(String name) {
        return super.getHeader(name);
    }
}

