/*
 * Decompiled with CFR 0.152.
 */
package com.didiglobal.logi.log.common.web.filter;

import com.didiglobal.logi.log.ILog;
import com.didiglobal.logi.log.LogFactory;
import com.didiglobal.logi.log.common.TraceContext;
import com.didiglobal.logi.log.common.URLHelper;
import com.didiglobal.logi.log.common.web.filter.TranslateHttpServletRequestWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.Ordered;
import org.springframework.web.util.ContentCachingResponseWrapper;
import org.springframework.web.util.WebUtils;

public class WebRequestLogFilter
implements Ordered,
Filter {
    private static final ILog LOGGER = LogFactory.getLog("accessLogger");
    private static final ILog RESP_LOGGER = LogFactory.getLog("responseLogger");
    public static final String RESPONSE_LOG_ENABLE = "responseLogEnable";
    public static final String EXCLUDE_URLS = "excludeAllUrls";
    public static final String EXCLUDE_REQUEST_BODY_URLS = "excludeReqBodyUrls";
    public static final String EXCLUDE_RESPONSE_BODY_URLS = "excludeRespBodyUrls";
    public static final String EXCLUDE_RESPONSE_BODY_URLS_PREFER = "excludeRespBodyUrlsPrefer";
    private static final Set<String> ALL_EXCLUDE_URLS = new HashSet<String>();
    private static final Set<String> REQ_BODY_EXCLUDE_URLS = new HashSet<String>();
    private static final Set<String> RESP_BODY_EXCLUDE_URLS = new HashSet<String>();
    private static final Set<String> RESP_BODY_EXCLUDE_URLS_PREFER = new HashSet<String>();
    private static Boolean RESP_LOG_ENABLE = Boolean.TRUE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        long begin = System.currentTimeMillis();
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        TranslateHttpServletRequestWrapper wrapperRequest = new TranslateHttpServletRequestWrapper(request);
        ContentCachingResponseWrapper wrapperResponse = new ContentCachingResponseWrapper(response);
        String requestUrl = request.getRequestURI();
        try {
            this.initTrace(request);
            this.logRequest(wrapperRequest, requestUrl);
            chain.doFilter((ServletRequest)wrapperRequest, (ServletResponse)wrapperResponse);
        }
        finally {
            try {
                this.logResponse(begin, wrapperResponse, requestUrl);
                wrapperResponse.copyBodyToResponse();
            }
            finally {
                LogFactory.removeFlag();
            }
        }
    }

    private void initTrace(HttpServletRequest request) {
        String cspanId;
        String traceid = request.getHeader("traceid");
        if (traceid == null) {
            traceid = request.getHeader("X-Request-ID");
        }
        if (traceid == null) {
            traceid = request.getHeader("flag");
        }
        if (traceid == null) {
            traceid = LogFactory.getUniqueFlag();
        }
        if ((cspanId = request.getHeader("cspanid")) == null) {
            cspanId = "-1";
        }
        TraceContext traceContext = new TraceContext(traceid, cspanId);
        LogFactory.setTrace(traceContext);
        LogFactory.setFlag(traceid);
    }

    private void logResponse(long begin, ContentCachingResponseWrapper wrapperResponse, String requestUrl) {
        if (!RESP_LOG_ENABLE.booleanValue()) {
            return;
        }
        if (ALL_EXCLUDE_URLS.contains(requestUrl)) {
            return;
        }
        String responseBody = RESP_BODY_EXCLUDE_URLS.contains(requestUrl) || this.matchPrefer(RESP_BODY_EXCLUDE_URLS_PREFER, requestUrl) ? "{\"exclude\":true}" : this.getResponseBody(wrapperResponse);
        RESP_LOGGER.info("response||responseBody={}||timeCost={}", (Object)responseBody, (Object)(System.currentTimeMillis() - begin));
    }

    private void logRequest(TranslateHttpServletRequestWrapper request, String requestUrl) {
        if (ALL_EXCLUDE_URLS.contains(requestUrl)) {
            return;
        }
        Map<String, String> headers = this.getHeaders((HttpServletRequest)request);
        String requestBody = REQ_BODY_EXCLUDE_URLS.contains(requestUrl) ? "{\"exclude\":true}" : this.getRequestBody(request);
        LOGGER.info("request||url={}||method={}||remoteAddr={}||headers={}||urlParams={}||body={}", request.getRequestURI(), request.getMethod(), URLHelper.getIpAddr((HttpServletRequest)request), headers, request.getQueryString(), requestBody, "UTF-8");
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.initExcludeUrl(filterConfig, EXCLUDE_URLS, ALL_EXCLUDE_URLS);
        this.initExcludeUrl(filterConfig, EXCLUDE_REQUEST_BODY_URLS, REQ_BODY_EXCLUDE_URLS);
        this.initExcludeUrl(filterConfig, EXCLUDE_RESPONSE_BODY_URLS, RESP_BODY_EXCLUDE_URLS);
        this.initExcludeUrl(filterConfig, EXCLUDE_RESPONSE_BODY_URLS_PREFER, RESP_BODY_EXCLUDE_URLS_PREFER);
        if (filterConfig.getInitParameter(RESPONSE_LOG_ENABLE) != null) {
            RESP_LOG_ENABLE = Boolean.valueOf(filterConfig.getInitParameter(RESPONSE_LOG_ENABLE));
        }
    }

    private String getResponseBody(ContentCachingResponseWrapper response) {
        byte[] buf;
        ContentCachingResponseWrapper wrapper = (ContentCachingResponseWrapper)WebUtils.getNativeResponse((ServletResponse)response, ContentCachingResponseWrapper.class);
        if (wrapper != null && (buf = wrapper.getContentAsByteArray()).length > 0) {
            String payload;
            try {
                payload = new String(buf, 0, buf.length, wrapper.getCharacterEncoding());
            }
            catch (UnsupportedEncodingException e) {
                try {
                    payload = new String(buf, 0, buf.length, "UTF-8");
                }
                catch (UnsupportedEncodingException e1) {
                    payload = "Unknown";
                }
            }
            return payload;
        }
        return "";
    }

    private Map<String, String> getHeaders(HttpServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("refer", request.getHeader("referer"));
        params.put("agent", request.getHeader("User-Agent"));
        params.put("X-SSO-USER", request.getHeader("X-SSO-USER"));
        return params;
    }

    private String getRequestBody(TranslateHttpServletRequestWrapper request) {
        try {
            String body = IOUtils.toString((InputStream)request.getInputStream(), (String)"UTF-8");
            return body.replace("\n", "");
        }
        catch (Exception e) {
            return "";
        }
    }

    private void initExcludeUrl(FilterConfig filterConfig, String excludeUrls, Set<String> urlContainers) {
        String allExcludeUrls = filterConfig.getInitParameter(excludeUrls);
        if (StringUtils.isNotBlank((CharSequence)allExcludeUrls)) {
            String[] pattern = allExcludeUrls.split(",");
            urlContainers.addAll(Arrays.asList(pattern));
        }
    }

    private boolean matchPrefer(Set<String> preferSet, String requestUrl) {
        if (CollectionUtils.isEmpty(preferSet)) {
            return false;
        }
        for (String prefer : preferSet) {
            if (!requestUrl.startsWith(prefer)) continue;
            return true;
        }
        return false;
    }

    public void destroy() {
    }

    public int getOrder() {
        return 0x7FFFFFF7;
    }
}

