/*
 * Decompiled with CFR 0.152.
 */
package com.didiglobal.logi.log.common.web.spring;

import com.alibaba.fastjson.JSON;
import com.didiglobal.logi.log.ILog;
import com.didiglobal.logi.log.LogFactory;
import com.didiglobal.logi.log.common.web.spring.RequestBodyCache;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@RestControllerAdvice
public class TunnelResponseBodyAdvice
implements ResponseBodyAdvice {
    private static final ILog LOGGER = LogFactory.getLog("responseLogger");

    public boolean supports(MethodParameter returnType, Class converterType) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        try {
            String clazzName = returnType.getDeclaringClass().getSimpleName();
            String javaMethodName = returnType.getMethod().getName();
            String url = request.getURI().getPath();
            String httpMethod = request.getMethod().name();
            String result = JSON.toJSONString((Object)body);
            String params = RequestBodyCache.getRequestBody();
            if (StringUtils.isBlank((CharSequence)params)) {
                params = ((ServletServerHttpRequest)request).getServletRequest().getQueryString();
            }
            LOGGER.info("response||javaMethod={}||httpUrl={}||params={}||result={}", clazzName + "." + javaMethodName, httpMethod + " " + url, params, result);
            Object object = body;
            return object;
        }
        finally {
            RequestBodyCache.clearRequestBody();
        }
    }
}

