/*
 * Decompiled with CFR 0.152.
 */
package com.didiglobal.logi.log.facade;

import com.didiglobal.logi.log.ILog;
import com.didiglobal.logi.log.util.FlagWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class Slf4jFacade
implements ILog {
    private static Marker MARKER = MarkerFactory.getMarker((String)"ILog");
    private Logger logger;
    private Logger errorLogger;

    public Slf4jFacade(String clazz) {
        this.logger = LoggerFactory.getLogger((String)clazz);
        this.errorLogger = LoggerFactory.getLogger((String)"errorLogger");
    }

    @Override
    public void trace(String format, Object arg) {
        this.logger.trace(FlagWrapper.wrapMessage(format), arg);
    }

    @Override
    public void trace(String format, Object arg1, Object arg2) {
        this.logger.trace(FlagWrapper.wrapMessage(format), arg1, arg2);
    }

    @Override
    public void trace(String format, Object ... arguments) {
        this.logger.trace(FlagWrapper.wrapMessage(format), arguments);
    }

    @Override
    public void debug(String format, Object arg) {
        this.logger.debug(FlagWrapper.wrapMessage(format), arg);
    }

    @Override
    public void debug(String format, Object arg1, Object arg2) {
        this.logger.debug(FlagWrapper.wrapMessage(format), arg1, arg2);
    }

    @Override
    public void debug(String format, Object ... arguments) {
        this.logger.debug(FlagWrapper.wrapMessage(format), arguments);
    }

    @Override
    public void info(String format, Object arg) {
        this.logger.info(FlagWrapper.wrapMessage(format), arg);
    }

    @Override
    public void info(String format, Object arg1, Object arg2) {
        this.logger.info(FlagWrapper.wrapMessage(format), arg1, arg2);
    }

    @Override
    public void info(String format, Object ... arguments) {
        this.logger.info(FlagWrapper.wrapMessage(format), arguments);
    }

    @Override
    public void warn(String format, Object arg) {
        this.logger.warn(FlagWrapper.wrapMessage(format), arg);
    }

    @Override
    public void warn(String format, Object ... arguments) {
        this.logger.warn(FlagWrapper.wrapMessage(format), arguments);
    }

    @Override
    public void warn(String format, Object arg1, Object arg2) {
        this.logger.warn(FlagWrapper.wrapMessage(format), arg1, arg2);
    }

    @Override
    public void error(String format, Object arg) {
        String wrapperMessage = FlagWrapper.wrapMessage(format);
        this.errorLogger.error(wrapperMessage, arg);
        this.logger.error(wrapperMessage, arg);
    }

    @Override
    public void error(String format, Object arg1, Object arg2) {
        String wrapperMessage = FlagWrapper.wrapMessage(format);
        this.errorLogger.error(wrapperMessage, arg1, arg2);
        this.logger.error(wrapperMessage, arg1, arg2);
    }

    @Override
    public void error(String format, Object ... arguments) {
        String wrapperMessage = FlagWrapper.wrapMessage(format);
        this.errorLogger.error(wrapperMessage, arguments);
        this.logger.error(wrapperMessage, arguments);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void trace(String message) {
        this.logger.trace(MARKER, FlagWrapper.wrapMessage(message));
    }

    @Override
    public void trace(String message, Throwable t) {
        this.logger.trace(MARKER, FlagWrapper.wrapMessage(message), t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void error(String message, Throwable e) {
        String msg = FlagWrapper.wrapExceptionMessage(message);
        this.errorLogger.error(MARKER, msg, e);
        this.logger.error(MARKER, msg, e);
    }

    @Override
    public void error(String message) {
        String msg = FlagWrapper.wrapExceptionMessage(message);
        this.errorLogger.error(MARKER, msg);
        this.logger.error(MARKER, msg);
    }

    @Override
    public void debug(String message) {
        this.logger.debug(MARKER, FlagWrapper.wrapMessage(message));
    }

    @Override
    public void info(String message) {
        this.logger.info(MARKER, FlagWrapper.wrapMessage(message));
    }

    @Override
    public void warn(String message) {
        this.logger.warn(MARKER, FlagWrapper.wrapMessage(message));
    }

    @Override
    public void warn(String message, Throwable e) {
        this.logger.warn(MARKER, FlagWrapper.wrapMessage(message), e);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public void debug(String message, Throwable e) {
        this.logger.debug(MARKER, FlagWrapper.wrapMessage(message), e);
    }

    @Override
    public void info(String message, Throwable e) {
        this.logger.info(MARKER, FlagWrapper.wrapMessage(message), e);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }
}

