/*
 * Decompiled with CFR 0.152.
 */
package com.didiglobal.logi.log.log4j2.appender;

import com.didiglobal.logi.log.log4j2.appender.NoRepeatRollingFileAppender;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.MutableLogEvent;
import org.apache.logging.log4j.util.StringMap;

class NoRepeatLogEvent {
    private AtomicInteger count = new AtomicInteger(0);
    private final LogEvent event;
    private final NoRepeatRollingFileAppender rollingFileAppender;
    private String value;

    NoRepeatLogEvent(LogEvent event, NoRepeatRollingFileAppender rollingFileAppender) {
        this.event = event.toImmutable();
        this.rollingFileAppender = rollingFileAppender;
        this.value = event.getLoggerFqcn() + "_" + event.getMessage().getFormattedMessage();
    }

    int incrementAndGet() {
        return this.count.incrementAndGet();
    }

    public AtomicInteger getCount() {
        return this.count;
    }

    boolean isRestrain() {
        return this.count.get() > 1;
    }

    private LogEvent generateEvent() {
        StringBuilder sb = new StringBuilder();
        sb.append(" count=").append(this.count).append(", ").append(this.event.getMessage().getFormattedMessage());
        MutableLogEvent logEvent = new MutableLogEvent(sb, null);
        logEvent.setTimeMillis(System.currentTimeMillis());
        logEvent.setThrown(this.event.getThrown());
        logEvent.setContextData((StringMap)this.event.getContextData());
        logEvent.setContextStack(this.event.getContextStack());
        logEvent.setLoggerFqcn(this.event.getLoggerFqcn());
        logEvent.setMarker(this.event.getMarker());
        logEvent.setLevel(this.event.getLevel());
        logEvent.setLoggerName(this.event.getLoggerName());
        logEvent.setThrown(this.event.getThrown());
        logEvent.setThreadId(Thread.currentThread().getId());
        logEvent.setThreadName(Thread.currentThread().getName());
        logEvent.setThreadPriority(Thread.currentThread().getPriority());
        logEvent.setEndOfBatch(this.event.isEndOfBatch());
        logEvent.setIncludeLocation(this.event.isIncludeLocation());
        logEvent.setNanoTime(this.event.getNanoTime());
        return logEvent;
    }

    void log() {
        this.rollingFileAppender.appendRestrain(this.generateEvent());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NoRepeatLogEvent)) {
            return false;
        }
        NoRepeatLogEvent that = (NoRepeatLogEvent)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return "{\"NoRepeatLogEvent\":{\"count\":\"" + this.count + "\",\"event\":" + this.event + ",\"value\":\"" + this.value + "\"}}";
    }
}

