/*
 * Decompiled with CFR 0.152.
 */
package com.didiglobal.logi.log.log4j2.appender;

import com.didiglobal.logi.log.log4j2.appender.NoRepeatLogEvent;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

class NoRepeatLogEventManager {
    private static final ScheduledExecutorService LOG_SCHEDULE = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "NoRepeatLogEventManager-schedule-pool");
        }
    });
    private static volatile ConcurrentMap<String, NoRepeatLogEvent> LOG_COUNT;

    NoRepeatLogEventManager() {
    }

    static NoRepeatLogEvent getNoRepeatLogEvent(String key) {
        return (NoRepeatLogEvent)LOG_COUNT.get(key);
    }

    static NoRepeatLogEvent putNoRepeatLogEventIfAbsent(String key, NoRepeatLogEvent logEvent) {
        return LOG_COUNT.putIfAbsent(key, logEvent);
    }

    static {
        LOG_SCHEDULE.scheduleWithFixedDelay(new LogCountSwitcher(), 60L, 60L, TimeUnit.SECONDS);
        LOG_COUNT = new ConcurrentHashMap<String, NoRepeatLogEvent>();
    }

    private static class LogCountSwitcher
    implements Runnable {
        private LogCountSwitcher() {
        }

        @Override
        public void run() {
            ConcurrentHashMap logAggregateResult = new ConcurrentHashMap();
            logAggregateResult.putAll(LOG_COUNT);
            LOG_COUNT = new ConcurrentHashMap();
            for (NoRepeatLogEvent noRepeatLogEvent : logAggregateResult.values()) {
                if (!noRepeatLogEvent.isRestrain()) continue;
                noRepeatLogEvent.log();
            }
        }
    }
}

