/*
 * Decompiled with CFR 0.152.
 */
package com.didiglobal.logi.log.util;

import java.lang.management.ManagementFactory;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public class FlagGenerator {
    private static AtomicInteger NEXT_INC = new AtomicInteger(new Random().nextInt());
    private static final int GEN_MACHINE;
    private final int curTime = (int)(System.currentTimeMillis() / 1000L);
    private final int curMachine = GEN_MACHINE;
    private final int curInc = NEXT_INC.getAndIncrement();

    public static FlagGenerator get() {
        return new FlagGenerator();
    }

    private static boolean isValid(String s) {
        if (s == null) {
            return false;
        }
        int len = s.length();
        if (len != 24) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') continue;
            return false;
        }
        return true;
    }

    private FlagGenerator() {
    }

    public String toStringBabble() {
        return FlagGenerator.babbleToMongod(this.toStringMongod());
    }

    private String toStringMongod() {
        byte[] b = this.toByteArray();
        StringBuilder buf = new StringBuilder(24);
        for (int i = 0; i < b.length; ++i) {
            int x = b[i] & 0xFF;
            String s = Integer.toHexString(x);
            if (s.length() == 1) {
                buf.append("0");
            }
            buf.append(s);
        }
        return buf.toString();
    }

    private byte[] toByteArray() {
        byte[] b = new byte[12];
        ByteBuffer bb = ByteBuffer.wrap(b);
        bb.putInt(this.curTime);
        bb.putInt(this.curMachine);
        bb.putInt(this.curInc);
        return b;
    }

    private static String _pos(String s, int p) {
        return s.substring(p * 2, p * 2 + 2);
    }

    private static String babbleToMongod(String b) {
        int i;
        if (!FlagGenerator.isValid(b)) {
            throw new IllegalArgumentException("invalid object id: " + b);
        }
        StringBuilder buf = new StringBuilder(24);
        for (i = 7; i >= 0; --i) {
            buf.append(FlagGenerator._pos(b, i));
        }
        for (i = 11; i >= 8; --i) {
            buf.append(FlagGenerator._pos(b, i));
        }
        return buf.toString();
    }

    public String toString() {
        return this.toStringMongod();
    }

    static {
        try {
            int machinePiece;
            try {
                StringBuilder sb = new StringBuilder();
                Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
                while (e.hasMoreElements()) {
                    NetworkInterface ni = e.nextElement();
                    sb.append(ni.toString());
                }
                machinePiece = sb.toString().hashCode() << 16;
            }
            catch (Throwable e) {
                machinePiece = new Random().nextInt() << 16;
            }
            int processId = new Random().nextInt();
            try {
                processId = ManagementFactory.getRuntimeMXBean().getName().hashCode();
            }
            catch (Throwable ni) {
                // empty catch block
            }
            ClassLoader loader = FlagGenerator.class.getClassLoader();
            int loaderId = loader != null ? System.identityHashCode(loader) : 0;
            StringBuilder sb = new StringBuilder();
            sb.append(Integer.toHexString(processId));
            sb.append(Integer.toHexString(loaderId));
            int processPiece = sb.toString().hashCode() & 0xFFFF;
            GEN_MACHINE = machinePiece | processPiece;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

