/*
 * Decompiled with CFR 0.152.
 */
package com.didiglobal.logi.security.controller.v1;

import com.didiglobal.logi.security.common.PagingData;
import com.didiglobal.logi.security.common.PagingResult;
import com.didiglobal.logi.security.common.Result;
import com.didiglobal.logi.security.common.dto.oplog.OplogQueryDTO;
import com.didiglobal.logi.security.common.vo.oplog.OplogVO;
import com.didiglobal.logi.security.service.OplogService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="logi-security-oplog\u76f8\u5173API\u63a5\u53e3", tags={"logi-security-\u64cd\u4f5c\u65e5\u5fd7\u76f8\u5173API\u63a5\u53e3"})
@RequestMapping(value={"/logi-security/api/v1/oplog"})
public class OplogController {
    @Autowired
    private OplogService oplogService;

    @PostMapping(value={"/page"})
    @ApiOperation(value="\u67e5\u8be2\u64cd\u4f5c\u65e5\u5fd7\u5217\u8868", notes="\u5206\u9875\u548c\u6761\u4ef6\u67e5\u8be2")
    public PagingResult<OplogVO> page(@RequestBody OplogQueryDTO queryDTO) {
        PagingData<OplogVO> pageOplog = this.oplogService.getOplogPage(queryDTO);
        return PagingResult.success(pageOplog);
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u83b7\u53d6\u64cd\u4f5c\u65e5\u5fd7\u8be6\u60c5", notes="\u6839\u636e\u64cd\u4f5c\u65e5\u5fd7id\u83b7\u53d6\u64cd\u4f5c\u65e5\u5fd7\u8be6\u60c5")
    @ApiImplicitParam(name="id", value="\u64cd\u4f5c\u65e5\u5fd7id", dataType="int", required=true)
    public Result<OplogVO> get(@PathVariable Integer id) {
        OplogVO oplogVO = this.oplogService.getOplogDetailByOplogId(id);
        return Result.success(oplogVO);
    }

    @GetMapping(value={"/type/list"})
    @ResponseBody
    @ApiOperation(value="\u83b7\u53d6\u65e5\u5fd7\u7684\u6a21\u5757\u5217\u8868", notes="")
    public Result<List<String>> types() {
        return Result.buildSucc(this.oplogService.listTargetType());
    }
}

