/*
 * Decompiled with CFR 0.152.
 */
package com.didiglobal.logi.security.dao.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.didiglobal.logi.security.common.entity.UserProject;
import com.didiglobal.logi.security.common.po.UserProjectPO;
import com.didiglobal.logi.security.dao.UserProjectDao;
import com.didiglobal.logi.security.dao.impl.BaseDaoImpl;
import com.didiglobal.logi.security.dao.mapper.UserProjectMapper;
import com.didiglobal.logi.security.util.CopyBeanUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class UserProjectDaoImpl
extends BaseDaoImpl<UserProjectPO>
implements UserProjectDao {
    @Autowired
    private UserProjectMapper userProjectMapper;

    @Override
    public List<Integer> selectUserIdListByProjectId(Integer projectId, int type) {
        if (projectId == null) {
            return new ArrayList<Integer>();
        }
        QueryWrapper queryWrapper = this.getQueryWrapperWithAppName();
        queryWrapper.select(new String[]{"user_id"});
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        queryWrapper.eq((Object)"user_type", (Object)type);
        List userIdList = this.userProjectMapper.selectObjs((Wrapper)queryWrapper);
        return userIdList.stream().map(Integer.class::cast).collect(Collectors.toList());
    }

    @Override
    public List<Integer> selectProjectIdListByUserIdList(List<Integer> userIdList) {
        if (CollectionUtils.isEmpty(userIdList)) {
            return new ArrayList<Integer>();
        }
        QueryWrapper queryWrapper = this.getQueryWrapperWithAppName();
        queryWrapper.select(new String[]{"project_id"}).in((Object)"user_id", userIdList);
        List projectIdList = this.userProjectMapper.selectObjs((Wrapper)queryWrapper);
        return projectIdList.stream().map(Integer.class::cast).collect(Collectors.toList());
    }

    @Override
    public void insertBatch(List<UserProject> userProjectList) {
        if (!CollectionUtils.isEmpty(userProjectList)) {
            for (UserProject project : userProjectList) {
                UserProjectPO userProjectPO = this.getByProjectAndUserId(project);
                if (null == userProjectPO) {
                    this.addUserProject(project);
                    continue;
                }
                this.updateUserProject(userProjectPO.getId(), project);
            }
        }
    }

    @Override
    public int deleteUserProject(List<UserProject> userProjectList) {
        int delNu = 0;
        if (!CollectionUtils.isEmpty(userProjectList)) {
            for (UserProject userProject : userProjectList) {
                QueryWrapper queryWrapper = this.getQueryWrapperWithAppName();
                queryWrapper.eq((Object)"project_id", (Object)userProject.getProjectId());
                queryWrapper.eq((Object)"user_id", (Object)userProject.getUserId());
                queryWrapper.eq(Objects.nonNull(userProject.getUserType()), (Object)"user_type", (Object)userProject.getUserType());
                delNu += this.userProjectMapper.delete((Wrapper)queryWrapper);
            }
        }
        return delNu;
    }

    @Override
    public void deleteByProjectId(Integer projectId) {
        QueryWrapper queryWrapper = this.getQueryWrapperWithAppName();
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        this.userProjectMapper.delete((Wrapper)queryWrapper);
    }

    @Override
    public void deleteByProjectIdAndUserType(Integer projectId, int userType) {
        QueryWrapper queryWrapper = this.getQueryWrapperWithAppName();
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        queryWrapper.eq((Object)"user_type", (Object)userType);
        this.userProjectMapper.delete((Wrapper)queryWrapper);
    }

    private int addUserProject(UserProject userProject) {
        UserProjectPO userProjectPO = CopyBeanUtil.copy(userProject, UserProjectPO.class);
        userProjectPO.setAppName(this.logiSecurityProper.getAppName());
        return this.userProjectMapper.insert(userProjectPO);
    }

    private UserProjectPO getByProjectAndUserId(UserProject userProject) {
        QueryWrapper queryWrapper = this.getQueryWrapperWithAppName();
        queryWrapper.eq((Object)"project_id", (Object)userProject.getProjectId());
        queryWrapper.eq((Object)"user_id", (Object)userProject.getUserId());
        queryWrapper.eq(Objects.nonNull(userProject.getUserType()), (Object)"user_type", (Object)userProject.getUserType());
        return (UserProjectPO)this.userProjectMapper.selectOne((Wrapper)queryWrapper);
    }

    private int updateUserProject(int id, UserProject userProject) {
        UserProjectPO userProjectPO = CopyBeanUtil.copy(userProject, UserProjectPO.class);
        userProjectPO.setId(id);
        return this.userProjectMapper.updateById(userProjectPO);
    }
}

