/*
 * Decompiled with CFR 0.152.
 */
package com.didiglobal.logi.security.dao.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.didiglobal.logi.security.common.entity.UserRole;
import com.didiglobal.logi.security.common.po.UserRolePO;
import com.didiglobal.logi.security.dao.UserRoleDao;
import com.didiglobal.logi.security.dao.impl.BaseDaoImpl;
import com.didiglobal.logi.security.dao.mapper.UserRoleMapper;
import com.didiglobal.logi.security.util.CopyBeanUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class UserRoleDaoImpl
extends BaseDaoImpl<UserRolePO>
implements UserRoleDao {
    @Autowired
    private UserRoleMapper userRoleMapper;

    @Override
    public List<Integer> selectUserIdListByRoleId(Integer roleId) {
        if (roleId == null) {
            return new ArrayList<Integer>();
        }
        QueryWrapper queryWrapper = this.getQueryWrapperWithAppName();
        queryWrapper.select(new String[]{"user_id"}).eq((Object)"role_id", (Object)roleId);
        List userIdList = this.userRoleMapper.selectObjs((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)userIdList)) {
            return new ArrayList<Integer>();
        }
        return userIdList.stream().map(Integer.class::cast).collect(Collectors.toList());
    }

    @Override
    public List<Integer> selectRoleIdListByUserId(Integer userId) {
        if (userId == null) {
            return new ArrayList<Integer>();
        }
        QueryWrapper userRoleWrapper = this.getQueryWrapperWithAppName();
        userRoleWrapper.select(new String[]{"role_id"}).eq((Object)"user_id", (Object)userId);
        List roleIdList = this.userRoleMapper.selectObjs((Wrapper)userRoleWrapper);
        return roleIdList.stream().map(Integer.class::cast).collect(Collectors.toList());
    }

    @Override
    public void insertBatch(List<UserRole> userRoleList) {
        if (!CollectionUtils.isEmpty(userRoleList)) {
            List<UserRolePO> userRolePOList = CopyBeanUtil.copyList(userRoleList, UserRolePO.class);
            for (UserRolePO userRolePO : userRolePOList) {
                userRolePO.setAppName(this.logiSecurityProper.getAppName());
                this.userRoleMapper.insert(userRolePO);
            }
        }
    }

    @Override
    public int deleteByUserIdOrRoleId(Integer userId, Integer roleId) {
        if (userId == null && roleId == null) {
            return 0;
        }
        QueryWrapper queryWrapper = this.getQueryWrapperWithAppName();
        ((QueryWrapper)queryWrapper.eq(userId != null, (Object)"user_id", (Object)userId)).eq(roleId != null, (Object)"role_id", (Object)roleId);
        return this.userRoleMapper.delete((Wrapper)queryWrapper);
    }

    @Override
    public int selectCountByRoleId(Integer roleId) {
        if (roleId == null) {
            return 0;
        }
        QueryWrapper queryWrapper = this.getQueryWrapperWithAppName();
        queryWrapper.eq((Object)"role_id", (Object)roleId);
        return this.userRoleMapper.selectCount((Wrapper)queryWrapper);
    }
}

