/*
 * Decompiled with CFR 0.152.
 */
package com.didiglobal.logi.security.extend.impl;

import com.didiglobal.logi.security.common.Result;
import com.didiglobal.logi.security.common.dto.account.AccountLoginDTO;
import com.didiglobal.logi.security.common.entity.user.User;
import com.didiglobal.logi.security.common.enums.ResultCode;
import com.didiglobal.logi.security.common.vo.user.UserBriefVO;
import com.didiglobal.logi.security.exception.LogiSecurityException;
import com.didiglobal.logi.security.extend.LoginExtend;
import com.didiglobal.logi.security.service.UserService;
import com.didiglobal.logi.security.util.AESUtils;
import com.didiglobal.logi.security.util.CopyBeanUtil;
import com.didiglobal.logi.security.util.HttpRequestUtil;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="logiSecurityDefaultLoginExtendImpl")
public class DefaultLoginExtendImpl
implements LoginExtend {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultLoginExtendImpl.class);
    @Autowired
    private UserService userService;

    @Override
    public UserBriefVO verifyLogin(AccountLoginDTO loginDTO, HttpServletRequest request, HttpServletResponse response) throws LogiSecurityException {
        User user = this.userService.getUserByUserName(loginDTO.getUserName());
        if (user == null) {
            throw new LogiSecurityException(ResultCode.USER_NOT_EXISTS);
        }
        String decodePasswd = AESUtils.decrypt(loginDTO.getPw());
        loginDTO.setPw(decodePasswd);
        if (!user.getPw().equals(loginDTO.getPw())) {
            throw new LogiSecurityException(ResultCode.USER_CREDENTIALS_ERROR);
        }
        this.initLoginContext(request, response, loginDTO.getUserName(), user.getId());
        return CopyBeanUtil.copy(user, UserBriefVO.class);
    }

    @Override
    public Result<Boolean> logout(HttpServletRequest request, HttpServletResponse response) {
        request.getSession().invalidate();
        response.setStatus(HttpRequestUtil.REDIRECT_CODE.intValue());
        return Result.buildSucc(Boolean.TRUE);
    }

    @Override
    public boolean interceptorCheck(HttpServletRequest request, HttpServletResponse response, String requestMappingValue, List<String> whiteMappingValues) throws IOException {
        if (StringUtils.isEmpty((Object)requestMappingValue)) {
            LOGGER.error("class=LoginServiceImpl||method=interceptorCheck||msg=uri illegal||uri={}", (Object)request.getRequestURI());
            return Boolean.FALSE;
        }
        for (String mapping : whiteMappingValues) {
            if (!requestMappingValue.contains(mapping)) continue;
            return Boolean.TRUE;
        }
        if (!this.hasLoginValid(request)) {
            this.logout(request, response);
            return Boolean.FALSE;
        }
        String operator = HttpRequestUtil.getOperator(request);
        User user = this.userService.getUserByUserName(operator);
        if (user == null) {
            throw new LogiSecurityException(ResultCode.USER_NOT_EXISTS);
        }
        this.initLoginContext(request, response, operator, user.getId());
        return Boolean.TRUE;
    }

    private void initLoginContext(HttpServletRequest request, HttpServletResponse response, String userName, Integer userId) {
        HttpSession session = request.getSession(true);
        session.setMaxInactiveInterval(HttpRequestUtil.COOKIE_OR_SESSION_MAX_AGE_UNIT_SEC.intValue());
        session.setAttribute("X-SSO-USER", (Object)userName);
        session.setAttribute("X-SSO-USER-ID", (Object)userId);
        Cookie cookieUserName = new Cookie("X-SSO-USER", userName);
        cookieUserName.setMaxAge(HttpRequestUtil.COOKIE_OR_SESSION_MAX_AGE_UNIT_SEC.intValue());
        cookieUserName.setPath("/");
        Cookie cookieUserId = new Cookie("X-SSO-USER-ID", userId.toString());
        cookieUserId.setMaxAge(HttpRequestUtil.COOKIE_OR_SESSION_MAX_AGE_UNIT_SEC.intValue());
        cookieUserId.setPath("/");
        response.addCookie(cookieUserName);
        response.addCookie(cookieUserId);
    }

    private boolean hasLoginValid(HttpServletRequest request) {
        String username = HttpRequestUtil.getOperator(request);
        if (StringUtils.isEmpty((Object)username)) {
            return false;
        }
        User user = this.userService.getUserByUserName(username);
        return null != user;
    }
}

