/*
 * Decompiled with CFR 0.152.
 */
package com.github.zregvart.maven.profile.activator;

import java.lang.reflect.Field;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.Profile;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.profile.DefaultProfileSelector;
import org.apache.maven.model.profile.ProfileActivationContext;
import org.apache.maven.model.profile.ProfileSelector;
import org.apache.maven.model.profile.activation.ProfileActivator;
import org.apache.maven.model.profile.activation.PropertyProfileActivator;
import org.mvel2.MVEL;

@Named(value="property")
@Singleton
public class ExpressionProfileActivator
implements ProfileActivator {
    final ProfileActivator defaultActivator;

    @Inject
    public ExpressionProfileActivator(ProfileSelector selector) {
        this((ProfileActivator)new PropertyProfileActivator());
        ExpressionProfileActivator.patchProfileSelector(selector);
    }

    ExpressionProfileActivator(ProfileActivator activator) {
        this.defaultActivator = activator;
    }

    public boolean isActive(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
        if (!ExpressionProfileActivator.shouldEvaluateExpression(profile.getActivation())) {
            return this.defaultActivator.isActive(profile, context, problems);
        }
        Activation activation = profile.getActivation();
        ActivationProperty property = activation.getProperty();
        String expression = property.getValue();
        HashMap<String, Profile> vars = new HashMap<String, Profile>();
        vars.putAll(context.getSystemProperties());
        vars.putAll(context.getProjectProperties());
        vars.putAll(context.getUserProperties());
        vars.put("$profile", profile);
        return MVEL.evalToBoolean((String)expression, (Object)context, vars);
    }

    public boolean presentInConfig(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
        if (profile == null) {
            return false;
        }
        return ExpressionProfileActivator.shouldEvaluateExpression(profile.getActivation()) || this.defaultActivator.presentInConfig(profile, context, problems);
    }

    static boolean shouldEvaluateExpression(Activation activation) {
        if (activation == null) {
            return false;
        }
        ActivationProperty property = activation.getProperty();
        if (property == null) {
            return false;
        }
        String name = property.getName();
        if (name == null) {
            return false;
        }
        String value = property.getValue();
        boolean canConsider = name.trim().startsWith("expression:") && value != null && !value.trim().isEmpty();
        return canConsider;
    }

    private static void patchProfileSelector(ProfileSelector selector) {
        try {
            Field activators = DefaultProfileSelector.class.getDeclaredField("activators");
            activators.setAccessible(true);
            List defaultActivators = (List)activators.get(selector);
            activators.set(selector, new FilteredActivatorsList(defaultActivators));
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Unable to subvert the `activators` field of DefaultProfileSelector in order to remove the default PropertyProfileActivator which messes up my style", e);
        }
    }

    private static final class FilteredActivatorsList
    extends AbstractList<ProfileActivator> {
        private final List<ProfileActivator> defaultActivators;

        private FilteredActivatorsList(List<ProfileActivator> defaultActivators) {
            this.defaultActivators = defaultActivators;
        }

        @Override
        public ProfileActivator get(int index) {
            int idx = -1;
            for (ProfileActivator activator : this.defaultActivators) {
                if (!(activator instanceof PropertyProfileActivator)) {
                    ++idx;
                }
                if (idx != index) continue;
                return activator;
            }
            throw new IndexOutOfBoundsException("Accessed" + index + " with size: " + this.size());
        }

        @Override
        public int size() {
            int size = 0;
            for (ProfileActivator activator : this.defaultActivators) {
                if (activator instanceof PropertyProfileActivator) continue;
                ++size;
            }
            return size;
        }
    }
}

