/*
 * Decompiled with CFR 0.152.
 */
package com.zsu.eden;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.zsu.eden.EdenApt;
import com.zsu.eden.EdenFile;
import com.zsu.eden.EdenSearch;
import com.zsu.eden.EdenService;
import com.zsu.eden.UtilKt;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.kotlin.config.SourceKotlinRootType;
import org.jetbrains.kotlin.idea.configuration.ModuleSourceRootMapKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/zsu/eden/ModuleAnnotatedHolder;", "", "module", "Lcom/intellij/openapi/module/Module;", "annotationFqn", "", "(Lcom/intellij/openapi/module/Module;Ljava/lang/String;)V", "edenService", "Lcom/zsu/eden/EdenService;", "generated", "", "Ljava/io/File;", "cleanAllGenerated", "", "create", "", "Companion", "eden-ide"})
public final class ModuleAnnotatedHolder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Module module;
    @NotNull
    private final String annotationFqn;
    @NotNull
    private final EdenService edenService;
    @NotNull
    private List<? extends File> generated;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Set<JpsModuleSourceRootType<?>> kotlinSourceRoots;
    private static final ExecutorService executor;

    public ModuleAnnotatedHolder(@NotNull Module module, @NotNull String annotationFqn) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)annotationFqn, (String)"annotationFqn");
        this.module = module;
        this.annotationFqn = annotationFqn;
        Project project = this.module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
        this.edenService = EdenService.Companion.getInstance(project);
        this.generated = CollectionsKt.emptyList();
    }

    public final boolean create() {
        EdenApt singleApt = this.edenService.getAllApt$eden_ide().get(this.annotationFqn);
        if (singleApt == null) {
            logger.warn("[" + this.annotationFqn + "] apt didn't exists when scan module [" + this.module.getName() + "]");
            return false;
        }
        List allFiles2 = (List)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<List<? extends EdenFile>>(this, singleApt){
            final /* synthetic */ ModuleAnnotatedHolder this$0;
            final /* synthetic */ EdenApt $singleApt;
            {
                this.this$0 = $receiver;
                this.$singleApt = $singleApt;
                super(0);
            }

            @NotNull
            public final List<EdenFile> invoke() {
                List list;
                List<KtNamedDeclaration> all = EdenSearch.INSTANCE.getAnnotatedElements(ModuleAnnotatedHolder.access$getModule$p(this.this$0), ModuleAnnotatedHolder.access$getAnnotationFqn$p(this.this$0));
                try {
                    list = this.$singleApt.processSingleModule(all);
                }
                catch (Exception e) {
                    UtilKt.logErrorIfNeeded(ModuleAnnotatedHolder.access$getLogger$cp(), "meet exception when process module [" + ModuleAnnotatedHolder.access$getModule$p(this.this$0).getName() + "] with [" + ModuleAnnotatedHolder.access$getAnnotationFqn$p(this.this$0) + "]!", e);
                    list = CollectionsKt.emptyList();
                }
                return list;
            }
        }));
        if (!((Collection)allFiles2).isEmpty()) {
            executor.execute(() -> ModuleAnnotatedHolder.create$lambda$1(this, allFiles2, singleApt));
        }
        return true;
    }

    public final void cleanAllGenerated() {
        Iterable $this$forEach$iv = this.generated;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            if (!it.exists()) continue;
            it.delete();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void create$lambda$1(ModuleAnnotatedHolder this$0, List $allFiles, EdenApt $singleApt) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$allFiles, (String)"$allFiles");
        this$0.cleanAllGenerated();
        Companion companion = Companion;
        Module module$iv = this$0.module;
        boolean $i$f$createFiles = false;
        if (!$allFiles.isEmpty()) {
            void this_$iv;
            VirtualFile sourceRoot$iv = ((Companion)this_$iv).guessRootPath($singleApt, module$iv);
            if (sourceRoot$iv == null) {
                logger.warn("no kotlin/java source root found in [" + module$iv.getName() + "]!");
            } else {
                File file = VfsUtilCore.virtualToIoFile((VirtualFile)sourceRoot$iv);
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"virtualToIoFile(sourceRoot)");
                File ioFile$iv = file;
                ArrayList added$iv = new ArrayList();
                for (EdenFile file$iv : $allFiles) {
                    file$iv.writeTo(ioFile$iv);
                    Path outputDirectory$iv = ioFile$iv.toPath();
                    if (((CharSequence)file$iv.getPackageName()).length() > 0) {
                        List list;
                        void $this$dropLastWhile$iv$iv;
                        Object object = new char[]{'.'};
                        object = StringsKt.split$default((CharSequence)file$iv.getPackageName(), (char[])object, (boolean)false, (int)0, (int)6, null);
                        boolean $i$f$dropLastWhile = false;
                        if (!$this$dropLastWhile$iv$iv.isEmpty()) {
                            ListIterator iterator$iv$iv = $this$dropLastWhile$iv$iv.listIterator($this$dropLastWhile$iv$iv.size());
                            while (iterator$iv$iv.hasPrevious()) {
                                String it$iv = (String)iterator$iv$iv.previous();
                                boolean bl = false;
                                if (((CharSequence)it$iv).length() == 0) continue;
                                list = CollectionsKt.take((Iterable)((Iterable)$this$dropLastWhile$iv$iv), (int)(iterator$iv$iv.nextIndex() + 1));
                                break;
                            }
                        } else {
                            list = CollectionsKt.emptyList();
                        }
                        for (String packageComponent$iv : list) {
                            outputDirectory$iv = outputDirectory$iv.resolve(packageComponent$iv);
                        }
                    }
                    Path outputPath$iv = outputDirectory$iv.resolve(file$iv.getName() + ".kt");
                    ((Collection)added$iv).add(outputPath$iv.toFile());
                }
                List it = added$iv;
                boolean bl = false;
                this$0.generated = it;
                sourceRoot$iv.refresh(true, true);
            }
        }
    }

    public static final /* synthetic */ Module access$getModule$p(ModuleAnnotatedHolder $this) {
        return $this.module;
    }

    public static final /* synthetic */ String access$getAnnotationFqn$p(ModuleAnnotatedHolder $this) {
        return $this.annotationFqn;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    static {
        Logger logger = Logger.getInstance(ModuleAnnotatedHolder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(ModuleAnnotatedHolder::class.java)");
        ModuleAnnotatedHolder.logger = logger;
        Object[] objectArray = new JpsModuleSourceRootType[2];
        JavaSourceRootType javaSourceRootType = JavaSourceRootType.SOURCE;
        Intrinsics.checkNotNullExpressionValue((Object)javaSourceRootType, (String)"SOURCE");
        objectArray[0] = (JpsModuleSourceRootType)javaSourceRootType;
        objectArray[1] = (JpsModuleSourceRootType)SourceKotlinRootType.INSTANCE;
        kotlinSourceRoots = SetsKt.hashSetOf((Object[])objectArray);
        executor = Executors.newSingleThreadExecutor();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JP\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142'\u0010\u0015\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00170\u0011\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\r0\u0016H\u0082\bJ\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/zsu/eden/ModuleAnnotatedHolder$Companion;", "", "()V", "executor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "kotlinSourceRoots", "", "Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "createFiles", "", "module", "Lcom/intellij/openapi/module/Module;", "allFiles", "", "Lcom/zsu/eden/EdenFile;", "apt", "Lcom/zsu/eden/EdenApt;", "addedCallback", "Lkotlin/Function1;", "Ljava/io/File;", "Lkotlin/ParameterName;", "name", "added", "guessRootPath", "Lcom/intellij/openapi/vfs/VirtualFile;", "eden-ide"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final void createFiles(Module module, List<? extends EdenFile> allFiles2, EdenApt apt, Function1<? super List<? extends File>, Unit> addedCallback) {
            boolean $i$f$createFiles = false;
            if (allFiles2.isEmpty()) {
                return;
            }
            VirtualFile sourceRoot = this.guessRootPath(apt, module);
            if (sourceRoot == null) {
                logger.warn("no kotlin/java source root found in [" + module.getName() + "]!");
                return;
            }
            File file = VfsUtilCore.virtualToIoFile((VirtualFile)sourceRoot);
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"virtualToIoFile(sourceRoot)");
            File ioFile = file;
            ArrayList added = new ArrayList();
            for (EdenFile edenFile : allFiles2) {
                edenFile.writeTo(ioFile);
                Path outputDirectory = ioFile.toPath();
                if (((CharSequence)edenFile.getPackageName()).length() > 0) {
                    List list;
                    void $this$dropLastWhile$iv;
                    Object object = new char[]{'.'};
                    object = StringsKt.split$default((CharSequence)edenFile.getPackageName(), (char[])object, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$dropLastWhile = false;
                    if (!$this$dropLastWhile$iv.isEmpty()) {
                        ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                        while (iterator$iv.hasPrevious()) {
                            String it = (String)iterator$iv.previous();
                            boolean bl = false;
                            if (((CharSequence)it).length() == 0) continue;
                            list = CollectionsKt.take((Iterable)((Iterable)$this$dropLastWhile$iv), (int)(iterator$iv.nextIndex() + 1));
                            break;
                        }
                    } else {
                        list = CollectionsKt.emptyList();
                    }
                    for (String packageComponent : list) {
                        outputDirectory = outputDirectory.resolve(packageComponent);
                    }
                }
                Path outputPath = outputDirectory.resolve(edenFile.getName() + ".kt");
                ((Collection)added).add(outputPath.toFile());
            }
            addedCallback.invoke(added);
            sourceRoot.refresh(true, true);
        }

        private final VirtualFile guessRootPath(EdenApt apt, Module module) {
            VirtualFile sourceRoot = apt.getGeneratePath(module);
            if (sourceRoot != null) {
                return sourceRoot;
            }
            String extProjectPath = ModuleSourceRootMapKt.getExternalProjectPath((Module)module);
            if (extProjectPath != null) {
                File file = new File(extProjectPath, "build/generated/ksp/" + apt.getKspVariant() + "/kotlin");
                if (!file.exists()) {
                    file.mkdirs();
                }
                return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
            }
            List list = ProjectUtil.getRootManager((Module)module).getSourceRoots(kotlinSourceRoots);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"module.rootManager.getSo\u2026eRoots(kotlinSourceRoots)");
            return (VirtualFile)CollectionsKt.firstOrNull((List)list);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

