/*
 * Decompiled with CFR 0.152.
 */
package com.zsu.ksp.ide;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.configuration.ModuleSourceRootMapKt;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u001a\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001\u001a\u000e\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001\u001a\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"KSP_GENERATE_DIR", "", "readKspFromProperties", "file", "Ljava/io/File;", "readKspPath", "element", "Lcom/intellij/psi/PsiElement;", "sendKspError", "", "notifyContent", "sendKspNotify", "sendKspWarning", "ide"})
public final class UtilKt {
    @NotNull
    private static final String KSP_GENERATE_DIR = "ksp_generate_dir";

    @Nullable
    public static final File readKspPath(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Module module = ProjectRootsUtilKt.getModule((PsiElement)element);
        if (module == null) {
            return null;
        }
        Module module2 = module;
        String string = ModuleSourceRootMapKt.getExternalProjectPath((Module)module2);
        if (string == null) {
            return null;
        }
        String modulePath = string;
        String moduleKspPath = UtilKt.readKspFromProperties(new File(modulePath, "gradle.properties"));
        if (moduleKspPath != null) {
            return new File(modulePath, moduleKspPath);
        }
        String string2 = element.getProject().getBasePath();
        if (string2 == null) {
            return null;
        }
        String projectPath = string2;
        String projectKspPath = UtilKt.readKspFromProperties(new File(projectPath, "gradle.properties"));
        if (projectKspPath != null) {
            return new File(modulePath, projectKspPath);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String readKspFromProperties(File file) {
        if (!file.exists()) {
            return null;
        }
        Closeable closeable = new FileInputStream(file);
        Throwable throwable = null;
        try {
            FileInputStream fin = (FileInputStream)closeable;
            boolean bl = false;
            Properties properties = new Properties();
            properties.load(fin);
            String string = properties.getProperty(KSP_GENERATE_DIR);
            return string;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static final void sendKspNotify(@NotNull String notifyContent) {
        Intrinsics.checkNotNullParameter((Object)notifyContent, (String)"notifyContent");
        Notifications.Bus.notify((Notification)new Notification("fast.ksp.generate.ide", "", notifyContent, NotificationType.INFORMATION));
    }

    public static final void sendKspError(@NotNull String notifyContent) {
        Intrinsics.checkNotNullParameter((Object)notifyContent, (String)"notifyContent");
        Notifications.Bus.notify((Notification)new Notification("fast.ksp.generate.ide", "Ksp-ide generate failed.", notifyContent, NotificationType.ERROR));
    }

    public static final void sendKspWarning(@NotNull String notifyContent) {
        Intrinsics.checkNotNullParameter((Object)notifyContent, (String)"notifyContent");
        Notifications.Bus.notify((Notification)new Notification("fast.ksp.generate.ide", "", notifyContent, NotificationType.WARNING));
    }
}

