/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.api;

import io.gitlab.arturbosch.detekt.api.ConfigAware;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.FallbackConfigProperty;
import io.gitlab.arturbosch.detekt.api.TransformedConfigProperty;
import io.gitlab.arturbosch.detekt.api.TransformedConfigPropertyWithAndroidVariants;
import io.gitlab.arturbosch.detekt.api.UnstableApi;
import io.gitlab.arturbosch.detekt.api.internal.PathFiltersKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.properties.ReadOnlyProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0007\u001a)\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\u00030\u0001\"\b\b\u0000\u0010\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u0002H\u0003\u00a2\u0006\u0002\u0010\u0006\u001aG\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\u00070\u0001\"\b\b\u0000\u0010\u0003*\u00020\u0004\"\b\b\u0001\u0010\u0007*\u00020\u00042\u0006\u0010\u0005\u001a\u0002H\u00032\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00070\t\u00a2\u0006\u0002\u0010\n\u001a1\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\u00030\u0001\"\b\b\u0000\u0010\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u0002H\u00032\u0006\u0010\f\u001a\u0002H\u0003\u00a2\u0006\u0002\u0010\r\u001aO\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\u00070\u0001\"\b\b\u0000\u0010\u0003*\u00020\u0004\"\b\b\u0001\u0010\u0007*\u00020\u00042\u0006\u0010\u0005\u001a\u0002H\u00032\u0006\u0010\f\u001a\u0002H\u00032\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00070\t\u00a2\u0006\u0002\u0010\u000e\u001a3\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\u00030\u0001\"\b\b\u0000\u0010\u0003*\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u0002H\u0003H\u0007\u00a2\u0006\u0002\u0010\u0012\u001aQ\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\u00070\u0001\"\b\b\u0000\u0010\u0003*\u00020\u0004\"\b\b\u0001\u0010\u0007*\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u0002H\u00032\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00070\tH\u0007\u00a2\u0006\u0002\u0010\u0013\u001a/\u0010\u0014\u001a\u0002H\u0003\"\b\b\u0000\u0010\u0003*\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u0002H\u0003H\u0002\u00a2\u0006\u0002\u0010\u0017\u00a8\u0006\u0018"}, d2={"config", "Lkotlin/properties/ReadOnlyProperty;", "Lio/gitlab/arturbosch/detekt/api/ConfigAware;", "T", "", "defaultValue", "(Ljava/lang/Object;)Lkotlin/properties/ReadOnlyProperty;", "U", "transformer", "Lkotlin/Function1;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Lkotlin/properties/ReadOnlyProperty;", "configWithAndroidVariants", "defaultAndroidValue", "(Ljava/lang/Object;Ljava/lang/Object;)Lkotlin/properties/ReadOnlyProperty;", "(Ljava/lang/Object;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Lkotlin/properties/ReadOnlyProperty;", "configWithFallback", "fallbackPropertyName", "", "(Ljava/lang/String;Ljava/lang/Object;)Lkotlin/properties/ReadOnlyProperty;", "(Ljava/lang/String;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Lkotlin/properties/ReadOnlyProperty;", "getValueOrDefault", "configAware", "propertyName", "(Lio/gitlab/arturbosch/detekt/api/ConfigAware;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "detekt-api"})
public final class ConfigPropertyKt {
    @NotNull
    public static final <T> ReadOnlyProperty<ConfigAware, T> config(@NotNull T defaultValue) {
        Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
        return ConfigPropertyKt.config(defaultValue, config.1.INSTANCE);
    }

    @NotNull
    public static final <T, U> ReadOnlyProperty<ConfigAware, U> config(@NotNull T defaultValue, @NotNull Function1<? super T, ? extends U> transformer) {
        Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
        Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
        return new TransformedConfigProperty<T, U>(defaultValue, transformer);
    }

    @UnstableApi(reason="fallback property handling is still under discussion")
    @NotNull
    public static final <T> ReadOnlyProperty<ConfigAware, T> configWithFallback(@NotNull String fallbackPropertyName, @NotNull T defaultValue) {
        Intrinsics.checkNotNullParameter((Object)fallbackPropertyName, (String)"fallbackPropertyName");
        Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
        return ConfigPropertyKt.configWithFallback(fallbackPropertyName, defaultValue, configWithFallback.1.INSTANCE);
    }

    @UnstableApi(reason="fallback property handling is still under discussion")
    @NotNull
    public static final <T, U> ReadOnlyProperty<ConfigAware, U> configWithFallback(@NotNull String fallbackPropertyName, @NotNull T defaultValue, @NotNull Function1<? super T, ? extends U> transformer) {
        Intrinsics.checkNotNullParameter((Object)fallbackPropertyName, (String)"fallbackPropertyName");
        Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
        Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
        return new FallbackConfigProperty<T, U>(fallbackPropertyName, defaultValue, transformer);
    }

    @NotNull
    public static final <T> ReadOnlyProperty<ConfigAware, T> configWithAndroidVariants(@NotNull T defaultValue, @NotNull T defaultAndroidValue) {
        Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
        Intrinsics.checkNotNullParameter(defaultAndroidValue, (String)"defaultAndroidValue");
        return ConfigPropertyKt.configWithAndroidVariants(defaultValue, defaultAndroidValue, configWithAndroidVariants.1.INSTANCE);
    }

    @NotNull
    public static final <T, U> ReadOnlyProperty<ConfigAware, U> configWithAndroidVariants(@NotNull T defaultValue, @NotNull T defaultAndroidValue, @NotNull Function1<? super T, ? extends U> transformer) {
        Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
        Intrinsics.checkNotNullParameter(defaultAndroidValue, (String)"defaultAndroidValue");
        Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
        return new TransformedConfigPropertyWithAndroidVariants<T, U>(defaultValue, defaultAndroidValue, transformer);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final <T> T getValueOrDefault(ConfigAware configAware, String propertyName, T defaultValue) {
        Object object;
        T t = defaultValue;
        if (t instanceof List) {
            boolean bl;
            block6: {
                Iterable $this$all$iv = (Iterable)defaultValue;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    Iterator iterator = $this$all$iv.iterator();
                    while (iterator.hasNext()) {
                        Object element$iv;
                        Object it = element$iv = iterator.next();
                        boolean bl2 = false;
                        if (it instanceof String) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            }
            if (bl) {
                List defaultValueAsListOfStrings = (List)defaultValue;
                object = PathFiltersKt.valueOrDefaultCommaSeparated(configAware, propertyName, defaultValueAsListOfStrings);
                return object;
            }
            String string = "Only lists of strings are supported. '" + propertyName + "' is invalid. ";
            boolean bl3 = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if ((t instanceof String ? true : t instanceof Boolean) ? true : t instanceof Integer) {
            object = configAware.valueOrDefault(propertyName, defaultValue);
            return object;
        }
        String string = defaultValue.getClass() + " is not supported for delegated config property '" + propertyName + "'. Use one of String, Boolean, Int or List<String> instead.";
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    public static final /* synthetic */ Object access$getValueOrDefault(ConfigAware configAware, String propertyName, Object defaultValue) {
        return ConfigPropertyKt.getValueOrDefault(configAware, propertyName, defaultValue);
    }
}

