/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.api.internal;

import io.gitlab.arturbosch.detekt.api.Extension;
import io.gitlab.arturbosch.detekt.api.internal.VersionsKt;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.Manifest;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\b\u0010\u0000\u001a\u0004\u0018\u00010\u0001\u001a\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0006\u0010\u0003\u001a\u00020\u0001\u00a8\u0006\u0004"}, d2={"whichDetekt", "", "whichJava", "whichOS", "detekt-api"})
public final class VersionsKt {
    @NotNull
    public static final String whichOS() {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"os.name\")");
        return string;
    }

    @NotNull
    public static final String whichJava() {
        String string = System.getProperty("java.runtime.version");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"java.runtime.version\")");
        return string;
    }

    @Nullable
    public static final String whichDetekt() {
        Enumeration<URL> enumeration = Extension.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"Extension::class.java.classLoader.getResources(\"META-INF/MANIFEST.MF\")");
        boolean bl = false;
        return (String)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration)), (Function1)whichDetekt.1.INSTANCE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String whichDetekt$readVersion(URL resource) {
        String string;
        Closeable closeable = resource.openStream();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl3 = false;
            string = new Manifest(it).getMainAttributes().getValue("DetektVersion");
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return string;
    }

    public static final /* synthetic */ String access$whichDetekt$readVersion(URL resource) {
        return VersionsKt.whichDetekt$readVersion(resource);
    }
}

