/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.api.internal;

import io.github.detekt.psi.KtFilesKt;
import io.gitlab.arturbosch.detekt.api.internal.SignaturesKt;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\f\u0010\t\u001a\u00020\u0003*\u00020\nH\u0000\u001a\f\u0010\u000b\u001a\u00020\u0003*\u00020\nH\u0002\u001a\f\u0010\f\u001a\u00020\u0003*\u00020\rH\u0002\u001a\f\u0010\u000e\u001a\u00020\u0003*\u00020\u0003H\u0002\u001a\f\u0010\u000f\u001a\u00020\u0003*\u00020\nH\u0000\u001a\f\u0010\u0010\u001a\u00020\u0003*\u00020\nH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"multipleWhitespaces", "Lkotlin/text/Regex;", "buildClassSignature", "", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "buildFunctionSignature", "element", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "buildFullSignature", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "extractClassName", "fileSignature", "Lorg/jetbrains/kotlin/psi/KtFile;", "formatElementName", "searchName", "searchSignature", "detekt-api"})
@SourceDebugExtension(value={"SMAP\nSignatures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Signatures.kt\nio/gitlab/arturbosch/detekt/api/internal/SignaturesKt\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n146#2:112\n1855#3,2:113\n*S KotlinDebug\n*F\n+ 1 Signatures.kt\nio/gitlab/arturbosch/detekt/api/internal/SignaturesKt\n*L\n71#1:112\n94#1:113,2\n*E\n"})
public final class SignaturesKt {
    @NotNull
    private static final Regex multipleWhitespaces = new Regex("\\s{2,}");

    @NotNull
    public static final String searchName(@NotNull PsiElement $this$searchName) {
        Intrinsics.checkNotNullParameter((Object)$this$searchName, (String)"<this>");
        Object object = LightClassUtilsKt.getNamedUnwrappedElement((PsiElement)$this$searchName);
        if (object == null || (object = object.getName()) == null || (object = SignaturesKt.formatElementName((String)object)) == null) {
            object = "<UnknownName>";
        }
        return object;
    }

    private static final String formatElementName(String $this$formatElementName) {
        return StringsKt.contains$default((CharSequence)$this$formatElementName, (char)File.separatorChar, (boolean)false, (int)2, null) ? StringsKt.substringAfterLast$default((String)$this$formatElementName, (char)File.separatorChar, null, (int)2, null) : $this$formatElementName;
    }

    @NotNull
    public static final String buildFullSignature(@NotNull PsiElement $this$buildFullSignature) {
        Intrinsics.checkNotNullParameter((Object)$this$buildFullSignature, (String)"<this>");
        String fullSignature = SignaturesKt.searchSignature($this$buildFullSignature);
        String parentSignatures2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)PsiUtilsKt.getParents((PsiElement)$this$buildFullSignature), (Function1)buildFullSignature.parentSignatures.1.INSTANCE), (Function1)buildFullSignature.parentSignatures.2.INSTANCE))), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
        if (((CharSequence)parentSignatures2).length() > 0) {
            fullSignature = parentSignatures2 + '$' + fullSignature;
        }
        PsiFile psiFile = $this$buildFullSignature.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"this.containingFile");
        String filename = KtFilesKt.getFileName((PsiFile)psiFile);
        if (!StringsKt.startsWith$default((String)fullSignature, (String)filename, (boolean)false, (int)2, null)) {
            fullSignature = filename + '$' + fullSignature;
        }
        return fullSignature;
    }

    private static final String extractClassName(PsiElement $this$extractClassName) {
        String string;
        PsiElement $this$getNonStrictParentOfType$iv = $this$extractClassName;
        boolean $i$f$getNonStrictParentOfType = false;
        KtClassOrObject ktClassOrObject = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtClassOrObject.class, (boolean)false);
        if ((ktClassOrObject != null && (ktClassOrObject = ktClassOrObject.getNameAsSafeName()) != null ? ktClassOrObject.asString() : (string = null)) == null) {
            string = "";
        }
        return string;
    }

    private static final String searchSignature(PsiElement $this$searchSignature) {
        PsiElement psiElement = $this$searchSignature;
        CharSequence charSequence = psiElement instanceof KtNamedFunction ? SignaturesKt.buildFunctionSignature((KtNamedFunction)$this$searchSignature) : (psiElement instanceof KtClassOrObject ? SignaturesKt.buildClassSignature((KtClassOrObject)$this$searchSignature) : (psiElement instanceof KtFile ? SignaturesKt.fileSignature((KtFile)$this$searchSignature) : $this$searchSignature.getText()));
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"when (this) {\n        is\u2026  else -> this.text\n    }");
        charSequence = StringsKt.replace$default((String)charSequence, (char)'\n', (char)' ', (boolean)false, (int)4, null);
        psiElement = multipleWhitespaces;
        String string = " ";
        return psiElement.replace(charSequence, string);
    }

    private static final String fileSignature(KtFile $this$fileSignature) {
        return $this$fileSignature.getPackageFqName().asString() + '.' + KtFilesKt.getFileName((PsiFile)((PsiFile)$this$fileSignature));
    }

    private static final String buildClassSignature(KtClassOrObject classOrObject) {
        List extendedEntries;
        String baseName = null;
        String string = classOrObject.getNameAsSafeName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"classOrObject.nameAsSafeName.asString()");
        baseName = string;
        List list = classOrObject.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"classOrObject.typeParameters");
        List typeParameters = list;
        if (typeParameters.size() > 0) {
            baseName = baseName + '<';
            baseName = baseName + CollectionsKt.joinToString$default((Iterable)typeParameters, (CharSequence)", ", null, null, (int)0, null, (Function1)buildClassSignature.1.INSTANCE, (int)30, null);
            baseName = baseName + '>';
        }
        if (!((Collection)(extendedEntries = classOrObject.getSuperTypeListEntries())).isEmpty()) {
            baseName = baseName + " : ";
        }
        Iterable $this$forEach$iv = extendedEntries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtSuperTypeListEntry it = (KtSuperTypeListEntry)element$iv;
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder().append(baseName);
            KtUserType ktUserType = it.getTypeAsUserType();
            String string2 = ktUserType != null ? ktUserType.getReferencedName() : null;
            if (string2 == null) {
                string2 = "";
            }
            baseName = stringBuilder.append(string2).toString();
        }
        return baseName;
    }

    private static final String buildFunctionSignature(KtNamedFunction element) {
        int n;
        int startOffset = PsiUtilsKt.getStartOffsetSkippingComments((PsiElement)((PsiElement)element)) - PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)element));
        if (element.getTypeReference() != null) {
            KtTypeReference ktTypeReference = element.getTypeReference();
            n = ktTypeReference != null ? PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)ktTypeReference)) : 0;
        } else {
            KtParameterList ktParameterList = element.getValueParameterList();
            n = ktParameterList != null ? PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)ktParameterList)) : 0;
        }
        int endOffset = n - PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)element));
        if (!(startOffset < endOffset)) {
            boolean bl = false;
            String string = "Error building function signature with range " + startOffset + " - " + endOffset + " for element: " + element.getText();
            throw new IllegalArgumentException(string.toString());
        }
        String string = element.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.text");
        String string2 = string.substring(startOffset, endOffset);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string2;
    }

    public static final /* synthetic */ String access$extractClassName(PsiElement $receiver) {
        return SignaturesKt.extractClassName($receiver);
    }
}

