/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.api.internal;

import io.github.detekt.utils.ResourcesKt;
import io.gitlab.arturbosch.detekt.api.Extension;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.Manifest;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\u0006\u0010\u0003\u001a\u00020\u0001\u001a\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u0006\u0010\u0006\u001a\u00020\u0001\u00a8\u0006\u0007"}, d2={"getManifestValue", "", "key", "whichDetekt", "whichJava", "whichKotlin", "whichOS", "detekt-api"})
@SourceDebugExtension(value={"SMAP\nVersions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Versions.kt\nio/gitlab/arturbosch/detekt/api/internal/VersionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,37:1\n1#2:38\n*E\n"})
public final class VersionsKt {
    @NotNull
    public static final String whichOS() {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"os.name\")");
        return string;
    }

    @NotNull
    public static final String whichJava() {
        String string = System.getProperty("java.runtime.version");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"java.runtime.version\")");
        return string;
    }

    @NotNull
    public static final String whichKotlin() {
        return VersionsKt.getManifestValue("KotlinImplementationVersion");
    }

    @NotNull
    public static final String whichDetekt() {
        return VersionsKt.getManifestValue("DetektVersion");
    }

    private static final String getManifestValue(String key) {
        Enumeration<URL> enumeration = Extension.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"Extension::class.java.cl\u2026s(\"META-INF/MANIFEST.MF\")");
        return (String)SequencesKt.first((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration)), (Function1)((Function1)new Function1<URL, String>(key){
            final /* synthetic */ String $key;
            {
                this.$key = $key;
                super(1);
            }

            @Nullable
            public final String invoke(URL it) {
                Object object;
                Object object2 = this.$key;
                try {
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    object = Result.constructor-impl((Object)VersionsKt.access$getManifestValue$readVersion((String)object2, it));
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                object2 = object;
                return (String)(Result.isFailure-impl((Object)object2) ? null : object2);
            }
        })));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String getManifestValue$readVersion(String $key, URL resource) {
        String string;
        Closeable closeable = ResourcesKt.openSafeStream((URL)resource);
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            string = new Manifest(it).getMainAttributes().getValue($key);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return string;
    }

    public static final /* synthetic */ String access$getManifestValue$readVersion(String $key, URL resource) {
        return VersionsKt.getManifestValue$readVersion($key, resource);
    }
}

