/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.api;

import io.github.detekt.psi.FilePath;
import io.github.detekt.psi.KtFilesKt;
import io.gitlab.arturbosch.detekt.api.Compactable;
import io.gitlab.arturbosch.detekt.api.SourceLocation;
import io.gitlab.arturbosch.detekt.api.TextLocation;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 )2\u00020\u0001:\u0001)B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nB'\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000eB)\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\r\u001a\u00020\f\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u001c\u001a\u00020\fH\u0016J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\fH\u00c6\u0003J\t\u0010 \u001a\u00020\u0007H\u00c6\u0003J1\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u00d6\u0003J\t\u0010&\u001a\u00020'H\u00d6\u0001J\t\u0010(\u001a\u00020\fH\u00d6\u0001R\u001e\u0010\t\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\r\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006*"}, d2={"Lio/gitlab/arturbosch/detekt/api/Location;", "Lio/gitlab/arturbosch/detekt/api/Compactable;", "source", "Lio/gitlab/arturbosch/detekt/api/SourceLocation;", "text", "Lio/gitlab/arturbosch/detekt/api/TextLocation;", "filePath", "Lio/github/detekt/psi/FilePath;", "(Lio/gitlab/arturbosch/detekt/api/SourceLocation;Lio/gitlab/arturbosch/detekt/api/TextLocation;Lio/github/detekt/psi/FilePath;)V", "endSource", "(Lio/gitlab/arturbosch/detekt/api/SourceLocation;Lio/gitlab/arturbosch/detekt/api/SourceLocation;Lio/gitlab/arturbosch/detekt/api/TextLocation;Lio/github/detekt/psi/FilePath;)V", "locationString", "", "file", "(Lio/gitlab/arturbosch/detekt/api/SourceLocation;Lio/gitlab/arturbosch/detekt/api/TextLocation;Ljava/lang/String;Ljava/lang/String;)V", "(Lio/gitlab/arturbosch/detekt/api/SourceLocation;Lio/gitlab/arturbosch/detekt/api/TextLocation;Ljava/lang/String;Lio/github/detekt/psi/FilePath;)V", "<set-?>", "getEndSource", "()Lio/gitlab/arturbosch/detekt/api/SourceLocation;", "getFile$annotations", "()V", "getFile", "()Ljava/lang/String;", "getFilePath", "()Lio/github/detekt/psi/FilePath;", "getSource", "getText", "()Lio/gitlab/arturbosch/detekt/api/TextLocation;", "compact", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "detekt-api"})
public final class Location
implements Compactable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SourceLocation source;
    @NotNull
    private final TextLocation text;
    @NotNull
    private final String file;
    @NotNull
    private final FilePath filePath;
    @NotNull
    private SourceLocation endSource;

    @Deprecated(message="Consider relative path by passing a [FilePath]")
    @JvmOverloads
    public Location(@NotNull SourceLocation source, @NotNull TextLocation text, @NotNull String file, @NotNull FilePath filePath) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.source = source;
        this.text = text;
        this.file = file;
        this.filePath = filePath;
        this.endSource = this.source;
    }

    public /* synthetic */ Location(SourceLocation sourceLocation, TextLocation textLocation, String string, FilePath filePath, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            Path path = Paths.get(string, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            filePath = FilePath.Companion.fromAbsolute(path);
        }
        this(sourceLocation, textLocation, string, filePath);
    }

    @NotNull
    public final SourceLocation getSource() {
        return this.source;
    }

    @NotNull
    public final TextLocation getText() {
        return this.text;
    }

    @NotNull
    public final String getFile() {
        return this.file;
    }

    @Deprecated(message="Use filePath instead", replaceWith=@ReplaceWith(expression="filePath.absolutePath.toString()", imports={}))
    public static /* synthetic */ void getFile$annotations() {
    }

    @NotNull
    public final FilePath getFilePath() {
        return this.filePath;
    }

    @NotNull
    public final SourceLocation getEndSource() {
        return this.endSource;
    }

    public Location(@NotNull SourceLocation source, @NotNull TextLocation text, @NotNull FilePath filePath) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this(source, text, ((Object)filePath.getAbsolutePath()).toString(), filePath);
    }

    public Location(@NotNull SourceLocation source, @NotNull SourceLocation endSource, @NotNull TextLocation text, @NotNull FilePath filePath) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)endSource, (String)"endSource");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this(source, text, ((Object)filePath.getAbsolutePath()).toString(), filePath);
        this.endSource = endSource;
    }

    @Deprecated(message="locationString was removed and won't get passed to the main constructor. Use queries on 'ktElement' instead.", replaceWith=@ReplaceWith(expression="Location(source, text, file)", imports={"io.gitlab.arturbosch.detekt.api.Location"}))
    public Location(@NotNull SourceLocation source, @NotNull TextLocation text, @NotNull String locationString, @NotNull String file) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)locationString, (String)"locationString");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this(source, text, file, null, 8, null);
    }

    @Override
    @NotNull
    public String compact() {
        return "" + this.filePath.getAbsolutePath() + ':' + this.source;
    }

    @Override
    @NotNull
    public String compactWithSignature() {
        return Compactable.DefaultImpls.compactWithSignature(this);
    }

    @NotNull
    public final SourceLocation component1() {
        return this.source;
    }

    @NotNull
    public final TextLocation component2() {
        return this.text;
    }

    @NotNull
    public final String component3() {
        return this.file;
    }

    @NotNull
    public final FilePath component4() {
        return this.filePath;
    }

    @NotNull
    public final Location copy(@NotNull SourceLocation source, @NotNull TextLocation text, @NotNull String file, @NotNull FilePath filePath) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return new Location(source, text, file, filePath);
    }

    public static /* synthetic */ Location copy$default(Location location, SourceLocation sourceLocation, TextLocation textLocation, String string, FilePath filePath, int n, Object object) {
        if ((n & 1) != 0) {
            sourceLocation = location.source;
        }
        if ((n & 2) != 0) {
            textLocation = location.text;
        }
        if ((n & 4) != 0) {
            string = location.file;
        }
        if ((n & 8) != 0) {
            filePath = location.filePath;
        }
        return location.copy(sourceLocation, textLocation, string, filePath);
    }

    @NotNull
    public String toString() {
        return "Location(source=" + this.source + ", text=" + this.text + ", file=" + this.file + ", filePath=" + this.filePath + ')';
    }

    public int hashCode() {
        int result = this.source.hashCode();
        result = result * 31 + this.text.hashCode();
        result = result * 31 + this.file.hashCode();
        result = result * 31 + this.filePath.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Location)) {
            return false;
        }
        Location location = (Location)other;
        if (!Intrinsics.areEqual((Object)this.source, (Object)location.source)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.text, (Object)location.text)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.file, (Object)location.file)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.filePath, (Object)location.filePath);
    }

    @Deprecated(message="Consider relative path by passing a [FilePath]")
    @JvmOverloads
    public Location(@NotNull SourceLocation source, @NotNull TextLocation text, @NotNull String file) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this(source, text, file, null, 8, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bJ\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a8\u0006\u000f"}, d2={"Lio/gitlab/arturbosch/detekt/api/Location$Companion;", "", "()V", "endLineAndColumn", "Lorg/jetbrains/kotlin/diagnostics/PsiDiagnosticUtils$LineAndColumn;", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "offset", "", "from", "Lio/gitlab/arturbosch/detekt/api/Location;", "lineAndColumn", "range", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/TextRange;", "startLineAndColumn", "detekt-api"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Location from(@NotNull PsiElement element, int offset) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            PsiDiagnosticUtils.LineAndColumn start = this.startLineAndColumn(element, offset);
            SourceLocation sourceLocation = new SourceLocation(start.getLine(), start.getColumn());
            PsiDiagnosticUtils.LineAndColumn end = this.endLineAndColumn(element, offset);
            SourceLocation endSourceLocation = new SourceLocation(end.getLine(), end.getColumn());
            TextLocation textLocation = new TextLocation(PsiUtilsKt.getStartOffset((PsiElement)element) + offset, PsiUtilsKt.getEndOffset((PsiElement)element) + offset);
            PsiFile psiFile = element.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            return new Location(sourceLocation, endSourceLocation, textLocation, KtFilesKt.toFilePath((PsiFile)psiFile));
        }

        public static /* synthetic */ Location from$default(Companion companion, PsiElement psiElement, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            return companion.from(psiElement, n);
        }

        @NotNull
        public final PsiDiagnosticUtils.LineAndColumn startLineAndColumn(@NotNull PsiElement element, int offset) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return this.lineAndColumn(element, new TextRange(element.getTextRange().getStartOffset() + offset, element.getTextRange().getEndOffset() + offset));
        }

        public static /* synthetic */ PsiDiagnosticUtils.LineAndColumn startLineAndColumn$default(Companion companion, PsiElement psiElement, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            return companion.startLineAndColumn(psiElement, n);
        }

        private final PsiDiagnosticUtils.LineAndColumn endLineAndColumn(PsiElement element, int offset) {
            return this.lineAndColumn(element, new TextRange(element.getTextRange().getEndOffset() + offset, element.getTextRange().getEndOffset() + offset));
        }

        static /* synthetic */ PsiDiagnosticUtils.LineAndColumn endLineAndColumn$default(Companion companion, PsiElement psiElement, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            return companion.endLineAndColumn(psiElement, n);
        }

        private final PsiDiagnosticUtils.LineAndColumn lineAndColumn(PsiElement element, TextRange range) {
            PsiFile psiFile = element.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            PsiDiagnosticUtils.LineAndColumn lineAndColumn = KtFilesKt.getLineAndColumnInPsiFile((PsiFile)psiFile, (TextRange)range);
            if (lineAndColumn == null) {
                lineAndColumn = new PsiDiagnosticUtils.LineAndColumn(-1, -1, null);
            }
            return lineAndColumn;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

