/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.api;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.HierarchicalConfig;
import java.util.LinkedList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0007H\u0014J\"\u0010\n\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0014\u00a8\u0006\f"}, d2={"Lio/gitlab/arturbosch/detekt/api/BaseConfig;", "Lio/gitlab/arturbosch/detekt/api/HierarchicalConfig;", "()V", "keySequence", "", "key", "tryParseBasedOnDefault", "", "result", "defaultResult", "valueOrDefaultInternal", "default", "detekt-api"})
public abstract class BaseConfig
implements HierarchicalConfig {
    @NotNull
    protected Object valueOrDefaultInternal(@NotNull String key, @Nullable Object result, @NotNull Object object) {
        Object object2;
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"default");
        try {
            Object object3;
            if (result != null) {
                if (result instanceof String) {
                    object3 = this.tryParseBasedOnDefault((String)result, object);
                } else {
                    if (Config.Companion.getPRIMITIVES().contains(Reflection.getOrCreateKotlinClass(object.getClass())) && Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(result.getClass()), (Object)Reflection.getOrCreateKotlinClass(object.getClass())) ^ true) {
                        throw (Throwable)new ClassCastException();
                    }
                    object3 = result;
                }
            } else {
                object3 = object;
            }
            object2 = object3;
        }
        catch (ClassCastException _) {
            String string = "Value \"" + result + "\" set for config parameter \"" + this.keySequence(key) + "\" is not of" + " required type " + Reflection.getOrCreateKotlinClass(object.getClass()).getSimpleName() + '.';
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        catch (NumberFormatException _) {
            String string = "Value \"" + result + "\" set for config parameter \"" + this.keySequence(key) + "\" is not of" + " required type " + Reflection.getOrCreateKotlinClass(object.getClass()).getSimpleName() + '.';
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return object2;
    }

    private final String keySequence(String key) {
        LinkedList<String> seq = new LinkedList<String>();
        HierarchicalConfig.Parent current = this.getParent();
        while (current != null) {
            seq.addFirst(current.getKey());
            Config config = current.getConfig();
            if (!(config instanceof HierarchicalConfig)) {
                config = null;
            }
            HierarchicalConfig hierarchicalConfig = (HierarchicalConfig)config;
            current = hierarchicalConfig != null ? hierarchicalConfig.getParent() : null;
        }
        String keySeq = CollectionsKt.joinToString$default((Iterable)seq, (CharSequence)" > ", null, null, (int)0, null, null, (int)62, null);
        CharSequence charSequence = keySeq;
        boolean bl = false;
        return charSequence.length() == 0 ? key : keySeq + " > " + key;
    }

    @NotNull
    protected Object tryParseBasedOnDefault(@NotNull String result, @NotNull Object defaultResult) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        Intrinsics.checkParameterIsNotNull((Object)defaultResult, (String)"defaultResult");
        Object object2 = defaultResult;
        if (object2 instanceof Integer) {
            String string = result;
            boolean bl = false;
            object = Integer.parseInt(string);
        } else if (object2 instanceof Boolean) {
            String string = result;
            boolean bl = false;
            object = Boolean.parseBoolean(string);
        } else if (object2 instanceof Double) {
            String string = result;
            boolean bl = false;
            object = Double.parseDouble(string);
        } else if (object2 instanceof String) {
            object = result;
        } else {
            throw (Throwable)new ClassCastException();
        }
        return object;
    }
}

