/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.api;

import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Location;
import io.gitlab.arturbosch.detekt.api.Metric;
import io.gitlab.arturbosch.detekt.api.SourceLocation;
import io.gitlab.arturbosch.detekt.api.TextLocation;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0016\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0018\u001a\u00020\u0007H\u0016J\b\u0010\u0019\u001a\u00020\u0007H\u0016J\b\u0010\u001a\u001a\u00020\u0007H\u0016J\b\u0010\u001b\u001a\u00020\u0007H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016\u00a8\u0006\u001c"}, d2={"Lio/gitlab/arturbosch/detekt/api/CodeSmell;", "Lio/gitlab/arturbosch/detekt/api/Finding;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "entity", "Lio/gitlab/arturbosch/detekt/api/Entity;", "message", "", "metrics", "", "Lio/gitlab/arturbosch/detekt/api/Metric;", "references", "(Lio/gitlab/arturbosch/detekt/api/Issue;Lio/gitlab/arturbosch/detekt/api/Entity;Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "getEntity", "()Lio/gitlab/arturbosch/detekt/api/Entity;", "id", "getId", "()Ljava/lang/String;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "getMessage", "getMetrics", "()Ljava/util/List;", "getReferences", "compact", "compactWithSignature", "messageOrDescription", "toString", "detekt-api"})
public class CodeSmell
implements Finding {
    @NotNull
    private final String id;
    @NotNull
    private final Issue issue;
    @NotNull
    private final Entity entity;
    @NotNull
    private final String message;
    @NotNull
    private final List<Metric> metrics;
    @NotNull
    private final List<Entity> references;

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String compact() {
        return this.getId() + " - " + this.getEntity().compact();
    }

    @Override
    @NotNull
    public String compactWithSignature() {
        return this.compact() + " - Signature=" + this.getEntity().getSignature();
    }

    @NotNull
    public String toString() {
        return "CodeSmell(issue=" + this.issue + ", " + "entity=" + this.getEntity() + ", " + "message=" + this.getMessage() + ", " + "metrics=" + this.getMetrics() + ", " + "references=" + this.getReferences() + ", " + "id='" + this.getId() + "')";
    }

    @Override
    @NotNull
    public String messageOrDescription() {
        CharSequence charSequence = this.getMessage();
        boolean bl = false;
        return charSequence.length() == 0 ? this.issue.getDescription() : this.getMessage();
    }

    @Override
    @NotNull
    public final Issue getIssue() {
        return this.issue;
    }

    @Override
    @NotNull
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    @NotNull
    public String getMessage() {
        return this.message;
    }

    @Override
    @NotNull
    public List<Metric> getMetrics() {
        return this.metrics;
    }

    @Override
    @NotNull
    public List<Entity> getReferences() {
        return this.references;
    }

    public CodeSmell(@NotNull Issue issue, @NotNull Entity entity, @NotNull String message, @NotNull List<Metric> metrics, @NotNull List<Entity> references) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull(metrics, (String)"metrics");
        Intrinsics.checkParameterIsNotNull(references, (String)"references");
        this.issue = issue;
        this.entity = entity;
        this.message = message;
        this.metrics = metrics;
        this.references = references;
        this.id = this.issue.getId();
    }

    public /* synthetic */ CodeSmell(Issue issue, Entity entity, String string, List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        boolean bl;
        if ((n & 8) != 0) {
            bl = false;
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            bl = false;
            list2 = CollectionsKt.emptyList();
        }
        this(issue, entity, string, list, list2);
    }

    @Override
    @NotNull
    public Location getLocation() {
        return Finding.DefaultImpls.getLocation(this);
    }

    @Override
    @NotNull
    public String getLocationAsString() {
        return Finding.DefaultImpls.getLocationAsString(this);
    }

    @Override
    @NotNull
    public SourceLocation getStartPosition() {
        return Finding.DefaultImpls.getStartPosition(this);
    }

    @Override
    @NotNull
    public TextLocation getCharPosition() {
        return Finding.DefaultImpls.getCharPosition(this);
    }

    @Override
    @NotNull
    public String getFile() {
        return Finding.DefaultImpls.getFile(this);
    }

    @Override
    @NotNull
    public String getSignature() {
        return Finding.DefaultImpls.getSignature(this);
    }

    @Override
    @NotNull
    public String getName() {
        return Finding.DefaultImpls.getName(this);
    }

    @Override
    @NotNull
    public String getInClass() {
        return Finding.DefaultImpls.getInClass(this);
    }

    @Override
    @Nullable
    public Metric metricByType(@NotNull String type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return Finding.DefaultImpls.metricByType(this, type);
    }
}

