/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.api;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Detektion;
import io.gitlab.arturbosch.detekt.api.Extension;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000bH&J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bR\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lio/gitlab/arturbosch/detekt/api/OutputReport;", "Lio/gitlab/arturbosch/detekt/api/Extension;", "()V", "ending", "", "getEnding", "()Ljava/lang/String;", "name", "getName", "render", "detektion", "Lio/gitlab/arturbosch/detekt/api/Detektion;", "write", "", "filePath", "Ljava/nio/file/Path;", "detekt-api"})
public abstract class OutputReport
implements Extension {
    @NotNull
    public abstract String getEnding();

    @Nullable
    public String getName() {
        return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName();
    }

    public final void write(@NotNull Path filePath, @NotNull Detektion detektion) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        Intrinsics.checkParameterIsNotNull((Object)detektion, (String)"detektion");
        String reportData = this.render(detektion);
        if (reportData != null) {
            boolean bl;
            boolean bl2 = StringsKt.endsWith$default((String)((Object)filePath.getFileName()).toString(), (String)this.getEnding(), (boolean)false, (int)2, null);
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl2) {
                boolean bl4 = false;
                String string = "The " + this.getName() + " needs to have a file ending of type ." + this.getEnding() + ", but was " + filePath.getFileName() + '.';
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            Path path = filePath.getParent();
            if (path != null) {
                Path path2 = path;
                bl3 = false;
                bl = false;
                Path it = path2;
                boolean bl5 = false;
                Files.createDirectories(it, new FileAttribute[0]);
            }
            String string = reportData;
            Path path3 = filePath;
            Charset charset = Charsets.UTF_8;
            bl = false;
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = byArray;
            Files.write(path3, byArray2, new OpenOption[0]);
        }
    }

    @Nullable
    public abstract String render(@NotNull Detektion var1);

    @Override
    @NotNull
    public String getId() {
        return Extension.DefaultImpls.getId(this);
    }

    @Override
    public int getPriority() {
        return Extension.DefaultImpls.getPriority(this);
    }

    @Override
    public void init(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Extension.DefaultImpls.init(this, config);
    }
}

