/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.api;

import io.gitlab.arturbosch.detekt.api.BaseRule;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.internal.PathFilters;
import io.gitlab.arturbosch.detekt.api.internal.PathMatchersKt;
import io.gitlab.arturbosch.detekt.api.internal.ValidationKt;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00062\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lio/gitlab/arturbosch/detekt/api/RuleSet;", "", "id", "", "Lio/gitlab/arturbosch/detekt/api/RuleSetId;", "rules", "", "Lio/gitlab/arturbosch/detekt/api/BaseRule;", "(Ljava/lang/String;Ljava/util/List;)V", "getId", "()Ljava/lang/String;", "pathFilters", "Lio/gitlab/arturbosch/detekt/api/internal/PathFilters;", "getPathFilters", "()Lio/gitlab/arturbosch/detekt/api/internal/PathFilters;", "setPathFilters", "(Lio/gitlab/arturbosch/detekt/api/internal/PathFilters;)V", "getRules", "()Ljava/util/List;", "accept", "Lio/gitlab/arturbosch/detekt/api/Finding;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isFileIgnored", "", "detekt-api"})
public final class RuleSet {
    @Nullable
    private PathFilters pathFilters;
    @NotNull
    private final String id;
    @NotNull
    private final List<BaseRule> rules;

    @Nullable
    public final PathFilters getPathFilters() {
        return this.pathFilters;
    }

    public final void setPathFilters(@Nullable PathFilters pathFilters) {
        this.pathFilters = pathFilters;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Finding> accept(@NotNull KtFile file, @NotNull BindingContext bindingContext) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext, (String)"bindingContext");
        if (this.isFileIgnored(file)) {
            list = CollectionsKt.emptyList();
        } else {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = this.rules;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                BaseRule it = (BaseRule)element$iv$iv;
                boolean bl = false;
                it.visitFile(file, bindingContext);
                Iterable list$iv$iv = it.getFindings();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    public static /* synthetic */ List accept$default(RuleSet ruleSet, KtFile ktFile, BindingContext bindingContext, int n, Object object) {
        if ((n & 2) != 0) {
            BindingContext bindingContext2 = BindingContext.EMPTY;
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"BindingContext.EMPTY");
            bindingContext = bindingContext2;
        }
        return ruleSet.accept(ktFile, bindingContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isFileIgnored(KtFile file) {
        PathFilters pathFilters = this.pathFilters;
        if (pathFilters == null) return false;
        Path path = Paths.get(PathMatchersKt.absolutePath(file), new String[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(file.absolutePath())");
        if (!pathFilters.isIgnored(path)) return false;
        return true;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final List<BaseRule> getRules() {
        return this.rules;
    }

    public RuleSet(@NotNull String id, @NotNull List<? extends BaseRule> rules) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull(rules, (String)"rules");
        this.id = id;
        this.rules = rules;
        ValidationKt.validateIdentifier(this.id);
    }
}

