/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.cli.runners;

import io.github.detekt.parser.KtCompiler;
import io.gitlab.arturbosch.detekt.cli.CliArgs;
import io.gitlab.arturbosch.detekt.cli.runners.ElementPrinter;
import io.gitlab.arturbosch.detekt.cli.runners.Executable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/gitlab/arturbosch/detekt/cli/runners/AstPrinter;", "Lio/gitlab/arturbosch/detekt/cli/runners/Executable;", "arguments", "Lio/gitlab/arturbosch/detekt/cli/CliArgs;", "outPrinter", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "(Lio/gitlab/arturbosch/detekt/cli/CliArgs;Ljava/lang/Appendable;)V", "execute", "", "detekt-cli"})
public final class AstPrinter
implements Executable {
    @NotNull
    private final CliArgs arguments;
    @NotNull
    private final Appendable outPrinter;

    public AstPrinter(@NotNull CliArgs arguments, @NotNull Appendable outPrinter) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)outPrinter, (String)"outPrinter");
        this.arguments = arguments;
        this.outPrinter = outPrinter;
    }

    @Override
    public void execute() {
        Path optionalInput;
        Path path = optionalInput = (Path)CollectionsKt.singleOrNull(this.arguments.getInputPaths());
        if (path == null) {
            boolean $i$a$-requireNotNull-AstPrinter$execute$input$22 = false;
            String $i$a$-requireNotNull-AstPrinter$execute$input$22 = "More than one input path specified. Printing AST is only supported for single files.";
            throw new IllegalArgumentException($i$a$-requireNotNull-AstPrinter$execute$input$22.toString());
        }
        Path input = path;
        if (!Files.isRegularFile(input, new LinkOption[0])) {
            boolean bl = false;
            String string = "Input path " + input + " must be a kotlin file and not a directory.";
            throw new IllegalArgumentException(string.toString());
        }
        KtFile ktFile = new KtCompiler(null, 1, null).compile(null, input);
        Appendable appendable = this.outPrinter.append(ElementPrinter.Companion.dump(ktFile));
        Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append('\\n')");
    }
}

