/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import io.gitlab.arturbosch.detekt.cli.CliArgs;
import io.gitlab.arturbosch.detekt.cli.HandledArgumentViolation;
import io.gitlab.arturbosch.detekt.cli.HelpRequest;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u001b\u0010\u0000\u001a\u00020\u00012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005\u001a\f\u0010\u0006\u001a\u00020\u0004*\u00020\u0007H\u0002\u001a\u0014\u0010\b\u001a\u00020\t*\u00020\u00012\u0006\u0010\n\u001a\u00020\u0007H\u0002\u00a8\u0006\u000b"}, d2={"parseArguments", "Lio/gitlab/arturbosch/detekt/cli/CliArgs;", "args", "", "", "([Ljava/lang/String;)Lio/gitlab/arturbosch/detekt/cli/CliArgs;", "usageAsString", "Lcom/beust/jcommander/JCommander;", "validate", "", "jCommander", "detekt-cli"})
@SourceDebugExtension(value={"SMAP\nJCommander.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JCommander.kt\nio/gitlab/arturbosch/detekt/cli/JCommanderKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,55:1\n1#2:56\n*E\n"})
public final class JCommanderKt {
    @NotNull
    public static final CliArgs parseArguments(@NotNull String[] args) {
        CliArgs cliArgs;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        CliArgs cli = new CliArgs();
        JCommander jCommander = new JCommander((Object)cli);
        jCommander.setProgramName("detekt");
        try {
            jCommander.parse(Arrays.copyOf(args, args.length));
        }
        catch (ParameterException ex) {
            throw new HandledArgumentViolation(ex.getMessage(), JCommanderKt.usageAsString(jCommander));
        }
        if (cli.getHelp()) {
            throw new HelpRequest(JCommanderKt.usageAsString(jCommander));
        }
        CliArgs $this$parseArguments_u24lambda_u240 = cliArgs = cli;
        boolean bl = false;
        JCommanderKt.validate($this$parseArguments_u24lambda_u240, jCommander);
        return cliArgs;
    }

    private static final String usageAsString(JCommander $this$usageAsString) {
        StringBuilder usage = new StringBuilder();
        $this$usageAsString.getUsageFormatter().usage(usage);
        String string = usage.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"usage.toString()");
        return string;
    }

    private static final void validate(CliArgs $this$validate, JCommander jCommander) {
        StringBuilder violations = new StringBuilder();
        Path baseline = $this$validate.getBaseline();
        if ($this$validate.getCreateBaseline() && baseline == null) {
            StringBuilder stringBuilder = violations.append("Creating a baseline.xml requires the --baseline parameter to specify a path.");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
        }
        if (!$this$validate.getCreateBaseline() && baseline != null) {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.notExists(baseline, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                StringBuilder stringBuilder = violations.append("The file specified by --baseline should exist '" + baseline + "'.");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
            } else {
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (!Files.isRegularFile(baseline, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                    StringBuilder stringBuilder = violations.append("The path specified by --baseline should be a file '" + baseline + "'.");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
                }
            }
        }
        if (((CharSequence)violations).length() > 0) {
            throw new HandledArgumentViolation(violations.toString(), JCommanderKt.usageAsString(jCommander));
        }
    }
}

