/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.cli;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lio/gitlab/arturbosch/detekt/cli/ReportPath;", "", "kind", "", "path", "Ljava/nio/file/Path;", "(Ljava/lang/String;Ljava/nio/file/Path;)V", "getKind", "()Ljava/lang/String;", "getPath", "()Ljava/nio/file/Path;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "detekt-cli"})
public final class ReportPath {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String kind;
    @NotNull
    private final Path path;
    private static final int NUM_OF_PARTS_UNIX = 2;
    private static final int NUM_OF_PARTS_WINDOWS = 3;
    @NotNull
    private static final String REPORT_PATH_SEPARATOR = ":";

    public ReportPath(@NotNull String kind, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.kind = kind;
        this.path = path;
    }

    @NotNull
    public final String getKind() {
        return this.kind;
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    @NotNull
    public final String component1() {
        return this.kind;
    }

    @NotNull
    public final Path component2() {
        return this.path;
    }

    @NotNull
    public final ReportPath copy(@NotNull String kind, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new ReportPath(kind, path);
    }

    public static /* synthetic */ ReportPath copy$default(ReportPath reportPath, String string, Path path, int n, Object object) {
        if ((n & 1) != 0) {
            string = reportPath.kind;
        }
        if ((n & 2) != 0) {
            path = reportPath.path;
        }
        return reportPath.copy(string, path);
    }

    @NotNull
    public String toString() {
        return "ReportPath(kind=" + this.kind + ", path=" + this.path + ')';
    }

    public int hashCode() {
        int result = this.kind.hashCode();
        result = result * 31 + ((Object)this.path).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ReportPath)) {
            return false;
        }
        ReportPath reportPath = (ReportPath)other;
        if (!Intrinsics.areEqual((Object)this.kind, (Object)reportPath.kind)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.path, (Object)reportPath.path);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/gitlab/arturbosch/detekt/cli/ReportPath$Companion;", "", "()V", "NUM_OF_PARTS_UNIX", "", "NUM_OF_PARTS_WINDOWS", "REPORT_PATH_SEPARATOR", "", "from", "Lio/gitlab/arturbosch/detekt/cli/ReportPath;", "input", "detekt-cli"})
    @SourceDebugExtension(value={"SMAP\nReportPath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReportPath.kt\nio/gitlab/arturbosch/detekt/cli/ReportPath$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,31:1\n1#2:32\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ReportPath from(@NotNull String input) {
            String string;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            String[] stringArray = new String[]{ReportPath.REPORT_PATH_SEPARATOR};
            List parts = StringsKt.split$default((CharSequence)input, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            int partsSize = parts.size();
            switch (partsSize) {
                case 2: {
                    string = (String)parts.get(1);
                    break;
                }
                case 3: {
                    string = CollectionsKt.joinToString$default((Iterable)CollectionsKt.slice((List)parts, (IntRange)RangesKt.until((int)1, (int)partsSize)), (CharSequence)ReportPath.REPORT_PATH_SEPARATOR, null, null, (int)0, null, null, (int)62, null);
                    break;
                }
                default: {
                    throw new IllegalStateException(("Input '" + input + "' must consist of two parts for Unix OSs or three for Windows (report-id:path).").toString());
                }
            }
            String path = string;
            String kind = (String)parts.get(0);
            if (!(((CharSequence)kind).length() > 0)) {
                boolean $i$a$-require-ReportPath$Companion$from$32 = false;
                String $i$a$-require-ReportPath$Companion$from$32 = "The kind of report must not be empty (path - " + path + ')';
                throw new IllegalArgumentException($i$a$-require-ReportPath$Companion$from$32.toString());
            }
            if (!(((CharSequence)path).length() > 0)) {
                boolean bl = false;
                String string2 = "The path of the report must not be empty (kind - " + kind + ')';
                throw new IllegalArgumentException(string2.toString());
            }
            Path path2 = Paths.get(path, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
            return new ReportPath(kind, path2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

