/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.cli.runners;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Detektion;
import io.gitlab.arturbosch.detekt.api.Notification;
import io.gitlab.arturbosch.detekt.api.internal.CommaSeparatedPattern;
import io.gitlab.arturbosch.detekt.api.internal.SimpleNotification;
import io.gitlab.arturbosch.detekt.api.internal.ValidatableConfigurationKt;
import io.gitlab.arturbosch.detekt.cli.BuildFailure;
import io.gitlab.arturbosch.detekt.cli.CliArgs;
import io.gitlab.arturbosch.detekt.cli.ConfigurationsKt;
import io.gitlab.arturbosch.detekt.cli.InvalidConfig;
import io.gitlab.arturbosch.detekt.cli.IssueExtensionKt;
import io.gitlab.arturbosch.detekt.cli.OutputFacade;
import io.gitlab.arturbosch.detekt.cli.runners.Executable;
import io.gitlab.arturbosch.detekt.core.DetektFacade;
import io.gitlab.arturbosch.detekt.core.ProcessingSettings;
import java.io.Closeable;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.LanguageVersion;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000f\u001a\u00020\rH\u0002J\b\u0010\u0010\u001a\u00020\tH\u0016J)\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u0002H\u00140\u0012\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0016H\u0082\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/gitlab/arturbosch/detekt/cli/runners/Runner;", "Lio/gitlab/arturbosch/detekt/cli/runners/Executable;", "arguments", "Lio/gitlab/arturbosch/detekt/cli/CliArgs;", "outputPrinter", "Ljava/io/PrintStream;", "errorPrinter", "(Lio/gitlab/arturbosch/detekt/cli/CliArgs;Ljava/io/PrintStream;Ljava/io/PrintStream;)V", "checkBuildFailureThreshold", "", "result", "Lio/gitlab/arturbosch/detekt/api/Detektion;", "settings", "Lio/gitlab/arturbosch/detekt/core/ProcessingSettings;", "checkConfiguration", "createSettings", "execute", "measure", "Lkotlin/Pair;", "", "T", "block", "Lkotlin/Function0;", "detekt-cli"})
public final class Runner
implements Executable {
    private final CliArgs arguments;
    private final PrintStream outputPrinter;
    private final PrintStream errorPrinter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void execute() {
        Closeable closeable = (Closeable)this.createSettings();
        boolean bl = false;
        Throwable throwable = null;
        try {
            void time;
            ProcessingSettings settings = (ProcessingSettings)closeable;
            boolean bl2 = false;
            this.checkConfiguration(settings);
            Runner this_$iv = this;
            boolean $i$f$measure = false;
            long start$iv = System.currentTimeMillis();
            boolean bl3 = false;
            Detektion result$iv = DetektFacade.Companion.create(settings).run();
            Pair pair = TuplesKt.to((Object)(System.currentTimeMillis() - start$iv), (Object)result$iv);
            long l = ((Number)pair.component1()).longValue();
            Detektion result = (Detektion)pair.component2();
            result.add((Notification)new SimpleNotification("detekt finished in " + (long)time + " ms.", null, 2, null));
            new OutputFacade(this.arguments, result, settings).run();
            if (!this.arguments.getCreateBaseline()) {
                this.checkBuildFailureThreshold(result, settings);
            }
            Disposer.dispose((Disposable)settings.getEnvironmentDisposable());
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkConfiguration(ProcessingSettings settings) {
        settings.debug((Function0)new Function0<String>(settings){
            final /* synthetic */ ProcessingSettings $settings;

            @NotNull
            public final String invoke() {
                return "" + '\n' + this.$settings.getConfig() + '\n';
            }
            {
                this.$settings = processingSettings;
                super(0);
            }
        });
        Config props = settings.getConfig().subConfig("config");
        boolean shouldValidate = (Boolean)props.valueOrDefault("validation", (Object)true);
        Function0<Set<? extends Regex>> $fun$patterns$2 = new Function0<Set<? extends Regex>>(props){
            final /* synthetic */ Config $props;

            @NotNull
            public final Set<Regex> invoke() {
                String excludes = (String)this.$props.valueOrDefault("excludes", (Object)"") + ',' + ValidatableConfigurationKt.getDEFAULT_PROPERTY_EXCLUDES();
                return new CommaSeparatedPattern(excludes, null, 2, null).mapToRegex();
            }
            {
                this.$props = config;
                super(0);
            }
        };
        if (shouldValidate) {
            void $this$filterTo$iv$iv;
            Object element$iv2;
            Iterator $this$mapTo$iv$iv;
            List notifications = ValidatableConfigurationKt.validateConfig((Config)settings.getConfig(), (Config)ConfigurationsKt.loadDefaultConfig(), (Set)$fun$patterns$2.invoke());
            Iterable $this$map$iv = notifications;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void receiver;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = ((Notification)receiver).getMessage();
                collection.add(string);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                String p1 = (String)element$iv2;
                boolean bl = false;
                settings.info(p1);
            }
            Iterable $this$filter$iv = notifications;
            boolean $i$f$filter = false;
            element$iv2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv;
                Object receiver = element$iv$iv = iterator2.next();
                boolean bl = false;
                if (!((Notification)receiver).isError()) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List errors = (List)destination$iv$iv2;
            $this$filter$iv = errors;
            boolean bl = false;
            if (!$this$filter$iv.isEmpty()) {
                String propsString = errors.size() == 1 ? "property" : "properties";
                throw (Throwable)new InvalidConfig("Run failed with " + errors.size() + " invalid config " + propsString + '.');
            }
        }
    }

    private final void checkBuildFailureThreshold(Detektion result, ProcessingSettings settings) {
        int amount = IssueExtensionKt.getOrComputeWeightedAmountOfIssues(result, settings.getConfig());
        int maxIssues = IssueExtensionKt.maxIssues(settings.getConfig());
        if (IssueExtensionKt.isValidAndSmallerOrEqual(maxIssues, amount)) {
            throw (Throwable)new BuildFailure("Build failed with " + amount + " weighted issues (threshold defined was " + maxIssues + ").");
        }
    }

    private final <T> Pair<Long, T> measure(Function0<? extends T> block) {
        int $i$f$measure = 0;
        long start = System.currentTimeMillis();
        Object result = block.invoke();
        return TuplesKt.to((Object)(System.currentTimeMillis() - start), (Object)result);
    }

    private final ProcessingSettings createSettings() {
        CliArgs cliArgs = this.arguments;
        boolean bl = false;
        boolean bl2 = false;
        CliArgs $this$with = cliArgs;
        boolean bl3 = false;
        PrintStream printStream = this.errorPrinter;
        PrintStream printStream2 = this.outputPrinter;
        boolean bl4 = this.arguments.getDebug();
        JvmTarget jvmTarget = $this$with.getJvmTarget();
        ExecutorService executorService = null;
        LanguageVersion languageVersion = $this$with.getLanguageVersion();
        List<String> list = ConfigurationsKt.createClasspath($this$with);
        List<Path> list2 = ConfigurationsKt.createPlugins($this$with);
        boolean bl5 = $this$with.getDisableDefaultRuleSets();
        boolean bl6 = $this$with.getAutoCorrect();
        return new ProcessingSettings($this$with.getInputPaths(), ConfigurationsKt.loadConfiguration($this$with), ConfigurationsKt.createFilters($this$with), $this$with.getParallel(), bl5, list2, list, languageVersion, jvmTarget, executorService, printStream2, printStream, bl6, bl4, 512, null);
    }

    public Runner(@NotNull CliArgs arguments, @NotNull PrintStream outputPrinter, @NotNull PrintStream errorPrinter) {
        Intrinsics.checkParameterIsNotNull((Object)arguments, (String)"arguments");
        Intrinsics.checkParameterIsNotNull((Object)outputPrinter, (String)"outputPrinter");
        Intrinsics.checkParameterIsNotNull((Object)errorPrinter, (String)"errorPrinter");
        this.arguments = arguments;
        this.outputPrinter = outputPrinter;
        this.errorPrinter = errorPrinter;
    }

    public /* synthetic */ Runner(CliArgs cliArgs, PrintStream printStream, PrintStream printStream2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            PrintStream printStream3 = System.out;
            Intrinsics.checkExpressionValueIsNotNull((Object)printStream3, (String)"System.out");
            printStream = printStream3;
        }
        if ((n & 4) != 0) {
            PrintStream printStream4 = System.err;
            Intrinsics.checkExpressionValueIsNotNull((Object)printStream4, (String)"System.err");
            printStream2 = printStream4;
        }
        this(cliArgs, printStream, printStream2);
    }
}

