/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.experimental;

import com.pinterest.ktlint.core.Rule;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002Je\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2K\u0010\u000e\u001aG\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u00040\u000fH\u0016J\f\u0010\u0016\u001a\u00020\r*\u00020\bH\u0002J\f\u0010\u0017\u001a\u00020\r*\u00020\bH\u0002\u00a8\u0006\u0019"}, d2={"Lcom/pinterest/ktlint/ruleset/experimental/EnumEntryNameCaseRule;", "Lcom/pinterest/ktlint/core/Rule;", "()V", "correct", "", "enumEntry", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "originalName", "", "visit", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "errorMessage", "canBeAutoCorrected", "containsLowerCase", "startsWithUpperCase", "Companion", "ktlint-ruleset-experimental"})
public final class EnumEntryNameCaseRule
extends Rule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ERROR_MESSAGE = "Enum entry name should be uppercase underscore-separated names like \"ENUM_ENTRY\" or upper camel-case like \"EnumEntry\"";

    public EnumEntryNameCaseRule() {
        super("enum-entry-name-case");
    }

    @Override
    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        KtEnumEntry ktEnumEntry;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(emit, (String)"emit");
        if (!(node instanceof CompositeElement)) {
            return;
        }
        Object object = ((CompositeElement)node).getPsi();
        KtEnumEntry ktEnumEntry2 = ktEnumEntry = object instanceof KtEnumEntry ? (KtEnumEntry)object : null;
        if (ktEnumEntry == null) {
            return;
        }
        KtEnumEntry enumEntry = ktEnumEntry;
        String string = enumEntry.getName();
        if (string == null) {
            return;
        }
        object = string;
        Object name = object;
        if (this.containsLowerCase((String)name)) {
            if (!this.startsWithUpperCase((String)name)) {
                emit.invoke((Object)((CompositeElement)node).getStartOffset(), (Object)ERROR_MESSAGE, (Object)false);
                if (autoCorrect) {
                    this.correct(enumEntry, (String)name);
                }
            } else if (StringsKt.contains$default((CharSequence)((CharSequence)name), (CharSequence)"_", (boolean)false, (int)2, null) && this.containsLowerCase((String)name)) {
                emit.invoke((Object)((CompositeElement)node).getStartOffset(), (Object)ERROR_MESSAGE, (Object)false);
                if (autoCorrect) {
                    this.correct(enumEntry, (String)name);
                }
            }
        }
    }

    private final void correct(KtEnumEntry enumEntry, String originalName) {
        String string = originalName;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toUpperCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toUpperCase()");
        enumEntry.setName(string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean startsWithUpperCase(String $this$startsWithUpperCase) {
        CharSequence charSequence = $this$startsWithUpperCase;
        boolean bl = false;
        if (charSequence.length() <= 0) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        char c = $this$startsWithUpperCase.charAt(0);
        bl = false;
        if (!Character.isUpperCase(c)) return false;
        return true;
    }

    private final boolean containsLowerCase(String $this$containsLowerCase) {
        boolean bl;
        block1: {
            CharSequence $this$any$iv = $this$containsLowerCase;
            boolean $i$f$any = false;
            CharSequence charSequence = $this$any$iv;
            for (int i = 0; i < charSequence.length(); ++i) {
                char element$iv;
                char it = element$iv = charSequence.charAt(i);
                boolean bl2 = false;
                char c = it;
                boolean bl3 = false;
                if (!Character.isLowerCase(c)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/pinterest/ktlint/ruleset/experimental/EnumEntryNameCaseRule$Companion;", "", "()V", "ERROR_MESSAGE", "", "ktlint-ruleset-experimental"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

