/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.formatting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J7\u0010\u0005\u001a)\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000b0\u00062\u0006\u0010\f\u001a\u00020\u0004H\u0002J5\u0010\r\u001a)\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000b0\u00062\u0006\u0010\f\u001a\u00020\u0004J\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/gitlab/arturbosch/detekt/formatting/KtLintLineColCalculator;", "", "()V", "UTF8_BOM", "", "buildPositionInTextLocator", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "offset", "Lkotlin/Pair;", "text", "calculateLineColByOffset", "normalizeText", "Segment", "SegmentTree", "detekt-formatting"})
public final class KtLintLineColCalculator {
    @NotNull
    public static final KtLintLineColCalculator INSTANCE = new KtLintLineColCalculator();
    @NotNull
    private static final String UTF8_BOM = "\ufeff";

    private KtLintLineColCalculator() {
    }

    @NotNull
    public final String normalizeText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return StringsKt.replaceFirst$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)text, (String)"\r\n", (String)"\n", (boolean)false, (int)4, null), (String)"\r", (String)"\n", (boolean)false, (int)4, null), (String)UTF8_BOM, (String)"", (boolean)false, (int)4, null);
    }

    @NotNull
    public final Function1<Integer, Pair<Integer, Integer>> calculateLineColByOffset(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.buildPositionInTextLocator(text);
    }

    private final Function1<Integer, Pair<Integer, Integer>> buildPositionInTextLocator(String text) {
        int textLength = text.length();
        ArrayList<Integer> arr = new ArrayList<Integer>();
        int endOfLineIndex = -1;
        do {
            arr.add(endOfLineIndex + 1);
        } while ((endOfLineIndex = StringsKt.indexOf$default((CharSequence)text, (char)'\n', (int)(endOfLineIndex + 1), (boolean)false, (int)4, null)) != -1);
        arr.add(textLength + (((Number)CollectionsKt.last((List)arr)).intValue() == textLength ? 1 : 0));
        SegmentTree segmentTree = new SegmentTree(CollectionsKt.toIntArray((Collection)arr));
        return (Function1)new Function1<Integer, Pair<? extends Integer, ? extends Integer>>(segmentTree){
            final /* synthetic */ SegmentTree $segmentTree;
            {
                this.$segmentTree = $segmentTree;
                super(1);
            }

            @NotNull
            public final Pair<Integer, Integer> invoke(int offset) {
                Pair pair;
                int line = this.$segmentTree.indexOf(offset);
                if (line != -1) {
                    int col = offset - this.$segmentTree.get(line).getLeft();
                    pair = TuplesKt.to((Object)(line + 1), (Object)(col + 1));
                } else {
                    pair = TuplesKt.to((Object)1, (Object)1);
                }
                return pair;
            }
        };
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0002J\u000e\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\tJ\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/gitlab/arturbosch/detekt/formatting/KtLintLineColCalculator$SegmentTree;", "", "sortedArray", "", "([I)V", "segments", "", "Lio/gitlab/arturbosch/detekt/formatting/KtLintLineColCalculator$Segment;", "binarySearch", "", "v", "l", "r", "get", "i", "indexOf", "detekt-formatting"})
    private static final class SegmentTree {
        @NotNull
        private final List<Segment> segments;

        /*
         * WARNING - void declaration
         */
        public SegmentTree(@NotNull int[] sortedArray) {
            Collection<Segment> collection;
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            int n;
            boolean bl;
            int n2;
            Intrinsics.checkNotNullParameter((Object)sortedArray, (String)"sortedArray");
            boolean bl2 = sortedArray.length > 1;
            boolean bl3 = false;
            boolean bl4 = false;
            if (!bl2) {
                boolean bl5 = false;
                String string = "At least two data points are required";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Object $this$reduce$iv = sortedArray;
            boolean $i$f$reduce = false;
            int[] nArray = $this$reduce$iv;
            int bl5 = 0;
            if (nArray.length == 0) {
                throw (Throwable)new UnsupportedOperationException("Empty array can't be reduced.");
            }
            int accumulator$iv22 = $this$reduce$iv[0];
            bl5 = 1;
            int n3 = ArraysKt.getLastIndex((int[])$this$reduce$iv);
            if (bl5 <= n3) {
                while (true) {
                    void next;
                    void index$iv;
                    int n4 = $this$reduce$iv[index$iv];
                    int current = accumulator$iv22;
                    boolean bl6 = false;
                    n2 = current <= next ? 1 : 0;
                    bl = false;
                    n = 0;
                    if (n2 == 0) {
                        boolean bl7 = false;
                        String string = "Data points are not sorted (ASC)";
                        throw (Throwable)new IllegalArgumentException(string.toString());
                    }
                    accumulator$iv22 = next;
                    if (index$iv == n3) break;
                    ++index$iv;
                }
            }
            $this$reduce$iv = ArraysKt.dropLast((int[])sortedArray, (int)1);
            SegmentTree segmentTree = this;
            boolean $i$f$mapIndexed = false;
            void accumulator$iv22 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void index;
                void element;
                n2 = index$iv$iv++;
                bl = false;
                if (n2 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                n = ((Number)item$iv$iv).intValue();
                int bl7 = n2;
                collection = destination$iv$iv;
                boolean bl8 = false;
                Segment segment = new Segment((int)element, sortedArray[index + true] - 1);
                collection.add(segment);
            }
            collection = (List)destination$iv$iv;
            segmentTree.segments = collection;
        }

        @NotNull
        public final Segment get(int i) {
            return this.segments.get(i);
        }

        public final int indexOf(int v) {
            return this.binarySearch(v, 0, this.segments.size() - 1);
        }

        private final int binarySearch(int v, int l, int r) {
            int i;
            Segment s;
            return l > r ? -1 : (v < (s = this.segments.get(i = l + (r - l) / 2)).getLeft() ? this.binarySearch(v, l, i - 1) : (s.getRight() < v ? this.binarySearch(v, i + 1, r) : i));
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lio/gitlab/arturbosch/detekt/formatting/KtLintLineColCalculator$Segment;", "", "left", "", "right", "(II)V", "getLeft", "()I", "getRight", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "detekt-formatting"})
    private static final class Segment {
        private final int left;
        private final int right;

        public Segment(int left, int right) {
            this.left = left;
            this.right = right;
        }

        public final int getLeft() {
            return this.left;
        }

        public final int getRight() {
            return this.right;
        }

        public final int component1() {
            return this.left;
        }

        public final int component2() {
            return this.right;
        }

        @NotNull
        public final Segment copy(int left, int right) {
            return new Segment(left, right);
        }

        public static /* synthetic */ Segment copy$default(Segment segment, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = segment.left;
            }
            if ((n3 & 2) != 0) {
                n2 = segment.right;
            }
            return segment.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "Segment(left=" + this.left + ", right=" + this.right + ')';
        }

        public int hashCode() {
            int result = Integer.hashCode(this.left);
            result = result * 31 + Integer.hashCode(this.right);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Segment)) {
                return false;
            }
            Segment segment = (Segment)other;
            if (this.left != segment.left) {
                return false;
            }
            return this.right == segment.right;
        }
    }
}

