/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.core;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.ec4j.core.ResourcePath;
import org.ec4j.core.model.Ec4jPath;

public interface Resource {
    public boolean exists();

    public ResourcePath getParent();

    public Ec4jPath getPath();

    public RandomReader openRandomReader() throws IOException;

    public Reader openReader() throws IOException;

    public static class Resources {
        public static Resource ofClassPath(ClassLoader loader, String path, Charset encoding) {
            return new ClassPathResource(loader, Ec4jPath.Ec4jPaths.of(path), encoding);
        }

        public static Resource ofPath(Path path, Charset encoding) {
            return new PathResource(path, encoding);
        }

        public static Resource ofString(String path, String content) {
            StringResourceTree tree = StringResourceTree.builder().resource(path, content).build();
            return tree.getResource(path);
        }

        public static StringResourceTree.Builder stringResourceTreeBuilder() {
            return new StringResourceTree.Builder();
        }

        private Resources() {
        }

        public static class StringResourceTree {
            private final Map<Ec4jPath, Resource> resources;

            public static Builder builder() {
                return new Builder();
            }

            StringResourceTree(Map<Ec4jPath, Resource> resources) {
                this.resources = resources;
            }

            public Resource getResource(Ec4jPath path) {
                return this.resources.get(path);
            }

            public Resource getResource(String path) {
                return this.resources.get(Ec4jPath.Ec4jPaths.of(path));
            }

            public static class Builder {
                private final Map<Ec4jPath, Resource> resources = new LinkedHashMap<Ec4jPath, Resource>();

                public StringResourceTree build() {
                    return new StringResourceTree(Collections.unmodifiableMap(this.resources));
                }

                public Builder resource(String path, String content) {
                    Ec4jPath p2 = Ec4jPath.Ec4jPaths.of(path);
                    this.resources.put(p2, new StringResource(this.resources, p2, content));
                    return this;
                }

                public Builder resource(String path, URL url, Charset encoding) throws IOException {
                    Ec4jPath segments = Ec4jPath.Ec4jPaths.of(path);
                    StringBuilder sb = new StringBuilder();
                    try (InputStreamReader r = new InputStreamReader(url.openStream(), encoding);){
                        int len;
                        char[] cbuf = new char[4096];
                        while ((len = r.read(cbuf)) >= 0) {
                            sb.append(cbuf, 0, len);
                        }
                    }
                    this.resources.put(segments, new StringResource(this.resources, segments, sb.toString()));
                    return this;
                }

                public Builder touch(String path) {
                    Ec4jPath segments = Ec4jPath.Ec4jPaths.of(path);
                    this.resources.put(segments, new StringResource(this.resources, segments, ""));
                    return this;
                }
            }
        }

        static class StringResource
        implements Resource {
            final String content;
            final Ec4jPath path;
            final Map<Ec4jPath, Resource> resources;

            StringResource(Map<Ec4jPath, Resource> resources, Ec4jPath path, String content) {
                this.path = path;
                this.resources = resources;
                this.content = content;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                StringResource other = (StringResource)obj;
                return this.path.equals(other.path);
            }

            @Override
            public boolean exists() {
                return this.resources.get(this.path) != null;
            }

            @Override
            public ResourcePath getParent() {
                Ec4jPath parentPath = this.path.getParentPath();
                return parentPath == null ? null : new ResourcePath.ResourcePaths.StringResourcePath(parentPath, this.resources);
            }

            @Override
            public Ec4jPath getPath() {
                return this.path;
            }

            public int hashCode() {
                return this.path.hashCode();
            }

            @Override
            public RandomReader openRandomReader() {
                return new StringRandomReader(this.content);
            }

            @Override
            public Reader openReader() {
                return new StringReader(this.content);
            }

            public String toString() {
                return "string:" + this.getPath();
            }
        }

        public static class StringRandomReader
        implements RandomReader {
            private final String content;

            public static RandomReader ofReader(Reader reader) throws IOException {
                int n;
                StringBuilder result = new StringBuilder();
                char[] buf = new char[4096];
                while ((n = reader.read(buf)) >= 0) {
                    result.append(buf, 0, n);
                }
                return new StringRandomReader(result.toString());
            }

            public static RandomReader ofString(String content) {
                return new StringRandomReader(content);
            }

            public static RandomReader ofUrl(URL url, Charset encoding) throws IOException {
                try (InputStreamReader r = new InputStreamReader(Bom.skipBom(url.openStream(), encoding), encoding);){
                    RandomReader randomReader = StringRandomReader.ofReader(r);
                    return randomReader;
                }
            }

            StringRandomReader(String content) {
                this.content = content;
            }

            @Override
            public void close() {
            }

            @Override
            public long getLength() {
                return this.content == null ? 0L : (long)this.content.length();
            }

            @Override
            public char read(long offset) {
                if (offset < 0L || offset >= this.getLength()) {
                    throw new IndexOutOfBoundsException("Cannot access index " + offset + " in string " + (this.content == null ? "null" : "\"" + this.content + "\""));
                }
                return this.content.charAt((int)offset);
            }
        }

        static class PathResource
        implements Resource {
            final Charset encoding;
            final Path path;

            PathResource(Path path, Charset encoding) {
                this.path = path;
                this.encoding = encoding;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                PathResource other = (PathResource)obj;
                return this.path.equals(other.path);
            }

            @Override
            public boolean exists() {
                return Files.exists(this.path, new LinkOption[0]);
            }

            @Override
            public ResourcePath getParent() {
                Path parent = this.path.getParent();
                return parent == null ? null : new ResourcePath.ResourcePaths.PathResourcePath(parent, this.encoding);
            }

            @Override
            public Ec4jPath getPath() {
                return Ec4jPath.Ec4jPaths.of(this.path);
            }

            public int hashCode() {
                return this.path.hashCode();
            }

            @Override
            public RandomReader openRandomReader() throws IOException {
                return new StringRandomReader(Bom.skipBom(Files.readAllBytes(this.path), this.encoding));
            }

            @Override
            public Reader openReader() throws IOException {
                CharsetDecoder decoder = this.encoding.newDecoder();
                InputStreamReader reader = new InputStreamReader(Bom.skipBom(Files.newInputStream(this.path, new OpenOption[0]), this.encoding), decoder);
                return new BufferedReader(reader);
            }

            public String toString() {
                return "path:" + this.getPath();
            }
        }

        static class ClassPathResource
        implements Resource {
            final Charset encoding;
            final ClassLoader loader;
            final Ec4jPath path;

            private static String removeInitialSlash(Ec4jPath path) {
                return Ec4jPath.Ec4jPaths.root().relativize(path).toString();
            }

            ClassPathResource(ClassLoader loader, Ec4jPath path, Charset encoding) {
                this.loader = loader;
                this.path = path;
                this.encoding = encoding;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                ClassPathResource other = (ClassPathResource)obj;
                if (this.loader == null ? other.loader != null : !this.loader.equals(other.loader)) {
                    return false;
                }
                return !(this.path == null ? other.path != null : !this.path.equals(other.path));
            }

            @Override
            public boolean exists() {
                return this.loader.getResource(ClassPathResource.removeInitialSlash(this.path)) != null;
            }

            @Override
            public ResourcePath getParent() {
                Ec4jPath parentPath = this.path.getParentPath();
                return parentPath == null ? null : new ResourcePath.ResourcePaths.ClassPathResourcePath(this.loader, parentPath, this.encoding);
            }

            @Override
            public Ec4jPath getPath() {
                return this.path;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.loader == null ? 0 : this.loader.hashCode());
                result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
                return result;
            }

            @Override
            public RandomReader openRandomReader() throws IOException {
                return StringRandomReader.ofUrl(this.loader.getResource(ClassPathResource.removeInitialSlash(this.path)), this.encoding);
            }

            @Override
            public Reader openReader() throws IOException {
                return new InputStreamReader(Bom.skipBom(this.loader.getResourceAsStream(ClassPathResource.removeInitialSlash(this.path)), this.encoding), this.encoding);
            }

            public String toString() {
                return "classpath:" + this.getPath();
            }
        }
    }

    public static interface RandomReader
    extends Closeable {
        public long getLength();

        public char read(long var1) throws IndexOutOfBoundsException;
    }

    public static class Charsets {
        private Charsets() {
        }

        public static Charset forName(String name) {
            Bom bom = Bom.ofName(name);
            if (bom != null) {
                return bom.getCharset();
            }
            return Charset.forName(name);
        }
    }

    public static enum Bom {
        UTF_8_BOM("utf-8-bom", new byte[]{-17, -69, -65}, StandardCharsets.UTF_8);

        private final byte[] bomBytes;
        private final Charset charset;
        private final String name;

        public static Bom ofName(String name) {
            String lcName = name.toLowerCase(Locale.ROOT);
            for (Bom bom : Bom.values()) {
                if (!bom.name.equals(lcName)) continue;
                return bom;
            }
            return null;
        }

        public static String skipBom(byte[] bytes, Charset charset) {
            if (charset instanceof BomCharset) {
                Bom bom = ((BomCharset)charset).getBom();
                int bomLength = bom.bomBytes.length;
                if (bytes.length == 0) {
                    return "";
                }
                if (bomLength > bytes.length) {
                    throw new IllegalStateException("Input too short; expected to start with Byte Order Mark (BOM)");
                }
                for (int i = 0; i < bomLength; ++i) {
                    byte c = bytes[i];
                    if (c == bom.bomBytes[i]) continue;
                    throw new IllegalStateException(String.format("Input expected to start with Byte Order Mark (BOM) [%s], found [0x%02X] at offset [%d]", bom.bomBytesHumanReadable(), c, i));
                }
                return new String(bytes, bomLength, bytes.length - bomLength, charset);
            }
            return new String(bytes, charset);
        }

        public static InputStream skipBom(InputStream inputStream, Charset charset) throws IOException {
            if (charset instanceof BomCharset) {
                Bom bom = ((BomCharset)charset).getBom();
                byte[] bytes = bom.bomBytes;
                for (int i = 0; i < bytes.length; ++i) {
                    int c = inputStream.read();
                    if (c < 0) {
                        if (i == 0) break;
                        inputStream.close();
                        throw new IllegalStateException("Premature end of stream; expected to start with Byte Order Mark (BOM)");
                    }
                    if ((byte)c == bytes[i]) continue;
                    inputStream.close();
                    throw new IllegalStateException(String.format("Stream expected to start with Byte Order Mark (BOM) [%s], found [0x%02X] at offset [%d]", bom.bomBytesHumanReadable(), c, i));
                }
            }
            return inputStream;
        }

        public static OutputStream writeBom(OutputStream outpuStream, Charset charset) throws IOException {
            if (charset instanceof BomCharset) {
                Bom bom = ((BomCharset)charset).getBom();
                outpuStream.write(bom.bomBytes);
            }
            return outpuStream;
        }

        private Bom(String name, byte[] bytes, Charset delegate) {
            this.name = name;
            this.bomBytes = bytes;
            this.charset = new BomCharset(this, delegate);
        }

        public String bomBytesHumanReadable() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.bomBytes.length; ++i) {
                if (i == 0) {
                    sb.append(String.format("0x%02X", this.bomBytes[i]));
                    continue;
                }
                sb.append(String.format(", 0x%02X", this.bomBytes[i]));
            }
            return sb.toString();
        }

        public byte[] getBomBytes() {
            byte[] result = new byte[this.bomBytes.length];
            System.arraycopy(this.bomBytes, 0, result, 0, this.bomBytes.length);
            return result;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public String getName() {
            return this.name;
        }

        static class BomCharset
        extends Charset {
            private static final String[] EMPTY_STRING_ARRAY = new String[0];
            private final Bom bom;
            private final Charset delegate;

            BomCharset(Bom bom, Charset delegate) {
                super(bom.getName(), EMPTY_STRING_ARRAY);
                this.delegate = delegate;
                this.bom = bom;
            }

            @Override
            public boolean contains(Charset cs) {
                return this.delegate.contains(cs);
            }

            public Bom getBom() {
                return this.bom;
            }

            @Override
            public CharsetDecoder newDecoder() {
                return this.delegate.newDecoder();
            }

            @Override
            public CharsetEncoder newEncoder() {
                return this.delegate.newEncoder();
            }
        }
    }
}

