/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.rule.engine.core.api.editorconfig;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.ec4j.core.model.PropertyType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0002\b\u0003\u0018\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0017\u0012\u0010\u0010\u0004\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00018\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0016R\u001c\u0010\u0004\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/SafeEnumValueParser;", "T", "", "Lorg/ec4j/core/model/PropertyType$PropertyValueParser;", "enumType", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "parse", "Lorg/ec4j/core/model/PropertyType$PropertyValue;", "name", "", "value", "ktlint-rule-engine-core"})
public final class SafeEnumValueParser<T extends Enum<?>>
implements PropertyType.PropertyValueParser<T> {
    @NotNull
    private final Class<? extends Enum<?>> enumType;

    public SafeEnumValueParser(@NotNull Class<? extends T> enumType) {
        Intrinsics.checkNotNullParameter(enumType, (String)"enumType");
        this.enumType = enumType;
    }

    @Override
    @NotNull
    public PropertyType.PropertyValue<T> parse(@Nullable String name, @Nullable String value) {
        PropertyType.PropertyValue<Object> propertyValue;
        if (value == null) {
            PropertyType.PropertyValue propertyValue2 = PropertyType.PropertyValue.invalid(value, "Cannot make enum " + this.enumType.getName() + " out of null");
            propertyValue = propertyValue2;
            Intrinsics.checkNotNullExpressionValue(propertyValue2, (String)"{\n            PropertyTy\u2026\" out of null\")\n        }");
        } else {
            PropertyType.PropertyValue<Enum<?>> propertyValue3;
            try {
                propertyValue3 = ((Object)StringsKt.trim((CharSequence)value)).toString();
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
                String string = ((String)((Object)propertyValue3)).toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(locale)");
                propertyValue3 = PropertyType.PropertyValue.valid(value, Enum.valueOf(this.enumType, string));
            }
            catch (IllegalArgumentException e) {
                propertyValue3 = PropertyType.PropertyValue.invalid(value, "Unexpected parsed \"" + value + "\" for enum " + this.enumType.getName());
            }
            PropertyType.PropertyValue<Enum<?>> propertyValue4 = propertyValue3;
            Intrinsics.checkNotNullExpressionValue(propertyValue4, (String)"{\n            try {\n    \u2026)\n            }\n        }");
            propertyValue = propertyValue4;
        }
        return propertyValue;
    }
}

