/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard.rules;

import com.pinterest.ktlint.rule.engine.core.api.ASTNodeExtensionKt;
import com.pinterest.ktlint.rule.engine.core.api.ElementType;
import com.pinterest.ktlint.rule.engine.core.api.IndentConfig;
import com.pinterest.ktlint.rule.engine.core.api.Rule;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.EditorConfig;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.EditorConfigProperty;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.IndentSizeEditorConfigPropertyKt;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.IndentStyleEditorConfigPropertyKt;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.MaxLineLengthEditorConfigPropertyKt;
import com.pinterest.ktlint.ruleset.standard.StandardRule;
import com.pinterest.ktlint.ruleset.standard.rules.WrappingRuleKt;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\f\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016Je\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2K\u0010\u0010\u001aG\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0016\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\b0\u0011H\u0016J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002Jm\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\r2K\u0010\u0010\u001aG\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0016\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\b0\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\f\u0010\u001c\u001a\u00020\u000f*\u00020\rH\u0002J\f\u0010\u001d\u001a\u00020\u0006*\u00020\rH\u0002J\f\u0010\u001e\u001a\u00020\u000f*\u00020\rH\u0002J\f\u0010\u001f\u001a\u00020\u000f*\u00020\rH\u0002J\f\u0010 \u001a\u00020\u000f*\u00020\rH\u0002J\u000e\u0010!\u001a\u0004\u0018\u00010\r*\u00020\rH\u0002J\u0014\u0010\"\u001a\u00020\u000f*\u00020\r2\u0006\u0010#\u001a\u00020$H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/rules/ArgumentListWrappingRule;", "Lcom/pinterest/ktlint/ruleset/standard/StandardRule;", "()V", "editorConfigIndent", "Lcom/pinterest/ktlint/rule/engine/core/api/IndentConfig;", "maxLineLength", "", "beforeFirstNode", "", "editorConfig", "Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/EditorConfig;", "beforeVisitChildNodes", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "", "emit", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "needToWrapArgumentList", "wrapArgumentInList", "newIndentLevel", "child", "exceedsMaxLineLength", "getNewIndentLevel", "hasTypeArgumentListInFront", "isOnSameLineAsControlFlowKeyword", "isPartOfDotQualifiedAssignmentExpression", "prevWhiteSpaceWithNewLine", "textContainsIgnoringLambda", "char", "", "ktlint-ruleset-standard"})
@SourceDebugExtension(value={"SMAP\nArgumentListWrappingRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArgumentListWrappingRule.kt\ncom/pinterest/ktlint/ruleset/standard/rules/ArgumentListWrappingRule\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,272:1\n1295#2,2:273\n1250#2,3:275\n1229#2:278\n1229#2,2:279\n1230#2:281\n179#2,2:282\n1229#2,2:284\n1#3:286\n142#4:287\n*S KotlinDebug\n*F\n+ 1 ArgumentListWrappingRule.kt\ncom/pinterest/ktlint/ruleset/standard/rules/ArgumentListWrappingRule\n*L\n86#1:273,2\n97#1:275,3\n222#1:278\n226#1:279,2\n222#1:281\n232#1:282,2\n234#1:284,2\n252#1:287\n*E\n"})
public final class ArgumentListWrappingRule
extends StandardRule {
    @NotNull
    private IndentConfig editorConfigIndent;
    private int maxLineLength;

    public ArgumentListWrappingRule() {
        Object[] objectArray = new EditorConfigProperty[]{IndentSizeEditorConfigPropertyKt.getINDENT_SIZE_PROPERTY(), IndentStyleEditorConfigPropertyKt.getINDENT_STYLE_PROPERTY(), MaxLineLengthEditorConfigPropertyKt.getMAX_LINE_LENGTH_PROPERTY()};
        super("argument-list-wrapping", SetsKt.setOf((Object)new Rule.VisitorModifier.RunAfterRule(WrappingRuleKt.getWRAPPING_RULE_ID(), Rule.VisitorModifier.RunAfterRule.Mode.REGARDLESS_WHETHER_RUN_AFTER_RULE_IS_LOADED_OR_DISABLED, null)), SetsKt.setOf((Object[])objectArray));
        this.editorConfigIndent = IndentConfig.Companion.getDEFAULT_INDENT_CONFIG();
        this.maxLineLength = ((Number)MaxLineLengthEditorConfigPropertyKt.getMAX_LINE_LENGTH_PROPERTY().getDefaultValue()).intValue();
    }

    @Override
    public void beforeFirstNode(@NotNull EditorConfig editorConfig) {
        Intrinsics.checkNotNullParameter((Object)editorConfig, (String)"editorConfig");
        this.editorConfigIndent = new IndentConfig(editorConfig.get(IndentStyleEditorConfigPropertyKt.getINDENT_STYLE_PROPERTY()), ((Number)editorConfig.get(IndentSizeEditorConfigPropertyKt.getINDENT_SIZE_PROPERTY())).intValue());
        this.maxLineLength = ((Number)editorConfig.get(MaxLineLengthEditorConfigPropertyKt.getMAX_LINE_LENGTH_PROPERTY())).intValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void beforeVisitChildNodes(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        if (this.editorConfigIndent.getDisabled()) {
            return;
        }
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getVALUE_ARGUMENT_LIST()) && this.needToWrapArgumentList(node)) {
            void $this$forEach$iv;
            int newIndentLevel = this.getNewIndentLevel(node);
            Sequence sequence = PsiUtilsKt.children((ASTNode)node);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ASTNode child = (ASTNode)element$iv;
                boolean bl = false;
                this.wrapArgumentInList(newIndentLevel, child, emit, autoCorrect);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean needToWrapArgumentList(ASTNode node) {
        ASTNode aSTNode = node.getFirstChildNode();
        if (Intrinsics.areEqual((Object)(aSTNode != null && (aSTNode = aSTNode.getTreeNext()) != null ? aSTNode.getElementType() : null), (Object)ElementType.INSTANCE.getRPAR())) return false;
        ASTNode aSTNode2 = node.getTreeParent();
        if (Intrinsics.areEqual((Object)(aSTNode2 != null ? aSTNode2.getElementType() : null), (Object)ElementType.INSTANCE.getFUNCTION_LITERAL())) return false;
        Sequence $this$count$iv = PsiUtilsKt.children((ASTNode)node);
        boolean $i$f$count = false;
        int count$iv = 0;
        for (Object element$iv : $this$count$iv) {
            ASTNode it = (ASTNode)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getVALUE_ARGUMENT()) || ++count$iv >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        if (count$iv > 8) return false;
        if (this.textContainsIgnoringLambda(node, '\n')) return true;
        if (!this.exceedsMaxLineLength(node)) return false;
        return true;
    }

    private final boolean exceedsMaxLineLength(ASTNode $this$exceedsMaxLineLength) {
        return ASTNodeExtensionKt.getColumn($this$exceedsMaxLineLength) - 1 + $this$exceedsMaxLineLength.getTextLength() > this.maxLineLength && !$this$exceedsMaxLineLength.textContains('\n');
    }

    private final int getNewIndentLevel(ASTNode $this$getNewIndentLevel) {
        int currentIndentLevel = this.editorConfigIndent.indentLevelFrom(ASTNodeExtensionKt.indent($this$getNewIndentLevel, false));
        int it = currentIndentLevel > 0 && this.hasTypeArgumentListInFront($this$getNewIndentLevel) ? currentIndentLevel - 1 : (currentIndentLevel > 0 && this.isPartOfDotQualifiedAssignmentExpression($this$getNewIndentLevel) ? currentIndentLevel - 1 : currentIndentLevel);
        boolean bl = false;
        return this.isOnSameLineAsControlFlowKeyword($this$getNewIndentLevel) ? it + 1 : it;
    }

    private final void wrapArgumentInList(int newIndentLevel, ASTNode child, Function3<? super Integer, ? super String, ? super Boolean, Unit> emit, boolean autoCorrect) {
        String indent = '\n' + StringsKt.repeat((CharSequence)this.editorConfigIndent.getIndent(), (int)newIndentLevel);
        IElementType iElementType = child.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getLPAR())) {
            ASTNode prevLeaf2 = ASTNodeExtensionKt.prevLeaf$default(child, false, 1, null);
            if (prevLeaf2 instanceof PsiWhiteSpace && prevLeaf2.textContains('\n')) {
                emit.invoke((Object)child.getStartOffset(), (Object)this.errorMessage(child), (Object)true);
                if (autoCorrect) {
                    ((PsiWhiteSpace)prevLeaf2).delete();
                }
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getVALUE_ARGUMENT()) ? true : Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getRPAR())) {
            ASTNode prevLeaf3;
            String intendedIndent = Intrinsics.areEqual((Object)child.getElementType(), (Object)ElementType.INSTANCE.getVALUE_ARGUMENT()) ? indent + this.editorConfigIndent.getIndent() : indent;
            ASTNode aSTNode = this.prevWhiteSpaceWithNewLine(child);
            if (aSTNode == null) {
                aSTNode = ASTNodeExtensionKt.prevLeaf$default(child, false, 1, null);
            }
            if ((prevLeaf3 = aSTNode) instanceof PsiWhiteSpace) {
                String string = prevLeaf3.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"prevLeaf.getText()");
                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"\n", (boolean)false, (int)2, null)) {
                    return;
                }
                emit.invoke((Object)child.getStartOffset(), (Object)this.errorMessage(child), (Object)true);
                if (autoCorrect) {
                    ((LeafPsiElement)prevLeaf3).rawReplaceWithText(intendedIndent);
                }
            } else {
                emit.invoke((Object)child.getStartOffset(), (Object)this.errorMessage(child), (Object)true);
                if (autoCorrect) {
                    child.getTreeParent().addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)intendedIndent), child);
                }
            }
        }
    }

    private final String errorMessage(ASTNode node) {
        String string;
        IElementType iElementType = node.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getLPAR())) {
            string = "Unnecessary newline before \"(\"";
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getVALUE_ARGUMENT())) {
            string = "Argument should be on a separate line (unless all arguments can fit a single line)";
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getRPAR())) {
            string = "Missing newline before \")\"";
        } else {
            throw new UnsupportedOperationException();
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean textContainsIgnoringLambda(ASTNode $this$textContainsIgnoringLambda, char c) {
        boolean bl;
        Sequence $this$any$iv = PsiUtilsKt.children((ASTNode)$this$textContainsIgnoringLambda);
        boolean $i$f$any = false;
        Iterator iterator = $this$any$iv.iterator();
        do {
            IElementType elementType;
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            ASTNode child = (ASTNode)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)child.getElementType(), (String)"child.elementType");
            if (Intrinsics.areEqual((Object)elementType, (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
                if (child.textContains(c)) return true;
            }
            if (Intrinsics.areEqual((Object)elementType, (Object)ElementType.INSTANCE.getCOLLECTION_LITERAL_EXPRESSION())) {
                if (child.textContains(c)) return true;
            }
            if (Intrinsics.areEqual((Object)elementType, (Object)ElementType.INSTANCE.getVALUE_ARGUMENT())) {
                Sequence $this$any$iv2 = PsiUtilsKt.children((ASTNode)child);
                boolean $i$f$any2 = false;
                for (Object element$iv2 : $this$any$iv2) {
                    ASTNode it = (ASTNode)element$iv2;
                    boolean bl3 = false;
                    if (!this.textContainsIgnoringLambda(it, c)) continue;
                    return true;
                }
                boolean bl4 = false;
                if (bl4) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasTypeArgumentListInFront(ASTNode $this$hasTypeArgumentListInFront) {
        boolean bl;
        Sequence sequence;
        Object v1;
        block4: {
            ASTNode aSTNode = $this$hasTypeArgumentListInFront.getTreeParent();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"treeParent");
            Sequence $this$firstOrNull$iv = PsiUtilsKt.children((ASTNode)aSTNode);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getTYPE_ARGUMENT_LIST())) continue;
                v1 = element$iv;
                break block4;
            }
            v1 = null;
        }
        ASTNode aSTNode = v1;
        if (aSTNode != null && (sequence = PsiUtilsKt.children((ASTNode)aSTNode)) != null) {
            boolean bl3;
            block5: {
                void $this$any$iv;
                Sequence $i$f$firstOrNull = sequence;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    ASTNode it = (ASTNode)element$iv;
                    boolean bl4 = false;
                    if (!ASTNodeExtensionKt.isWhiteSpaceWithNewline(it)) continue;
                    bl3 = true;
                    break block5;
                }
                bl3 = false;
            }
            bl = bl3;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPartOfDotQualifiedAssignmentExpression(ASTNode $this$isPartOfDotQualifiedAssignmentExpression) {
        Object v5;
        block1: {
            ASTNode aSTNode = $this$isPartOfDotQualifiedAssignmentExpression.getTreeParent();
            if (!Intrinsics.areEqual((Object)(aSTNode != null && (aSTNode = aSTNode.getTreeParent()) != null ? aSTNode.getElementType() : null), (Object)ElementType.INSTANCE.getBINARY_EXPRESSION())) return false;
            ASTNode aSTNode2 = $this$isPartOfDotQualifiedAssignmentExpression.getTreeParent();
            ASTNode aSTNode3 = aSTNode2;
            if (aSTNode2 == null) return false;
            ASTNode aSTNode4 = aSTNode3.getTreeParent();
            aSTNode3 = aSTNode4;
            if (aSTNode4 == null) return false;
            Sequence sequence = PsiUtilsKt.children((ASTNode)aSTNode3);
            aSTNode3 = sequence;
            if (sequence == null) return false;
            ASTNode aSTNode5 = aSTNode3;
            for (Object e : aSTNode5) {
                ASTNode it = (ASTNode)e;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getDOT_QUALIFIED_EXPRESSION())) continue;
                v5 = e;
                break block1;
            }
            v5 = null;
        }
        ASTNode aSTNode = v5;
        if (aSTNode == null) return false;
        return true;
    }

    private final ASTNode prevWhiteSpaceWithNewLine(ASTNode $this$prevWhiteSpaceWithNewLine) {
        ASTNode prev = ASTNodeExtensionKt.prevLeaf$default($this$prevWhiteSpaceWithNewLine, false, 1, null);
        while (prev != null && (ASTNodeExtensionKt.isWhiteSpace(prev) || ASTNodeExtensionKt.isPartOfComment(prev))) {
            if (ASTNodeExtensionKt.isWhiteSpaceWithNewline(prev)) {
                return prev;
            }
            prev = ASTNodeExtensionKt.prevLeaf$default(prev, false, 1, null);
        }
        return null;
    }

    private final boolean isOnSameLineAsControlFlowKeyword(ASTNode $this$isOnSameLineAsControlFlowKeyword) {
        Object object;
        PsiElement psiElement = $this$isOnSameLineAsControlFlowKeyword.getPsi();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"psi");
        PsiElement $this$getStrictParentOfType$iv = psiElement;
        boolean $i$f$getStrictParentOfType = false;
        KtContainerNode ktContainerNode = (KtContainerNode)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtContainerNode.class, (boolean)true);
        if (ktContainerNode == null) {
            return false;
        }
        KtContainerNode containerNode = ktContainerNode;
        if (Intrinsics.areEqual((Object)containerNode.getNode().getElementType(), (Object)ElementType.INSTANCE.getELSE())) {
            return false;
        }
        PsiElement parent = containerNode.getParent();
        if (parent instanceof KtIfExpression) {
            object = ((KtIfExpression)parent).getIfKeyword().getNode();
        } else if (parent instanceof KtWhileExpression) {
            object = ((KtWhileExpression)parent).getFirstChild().getNode();
        } else if (parent instanceof KtDoWhileExpression) {
            PsiElement psiElement2 = ((KtDoWhileExpression)parent).getWhileKeyword();
            object = psiElement2 != null ? psiElement2.getNode() : null;
        } else {
            object = null;
        }
        if (object == null) {
            return false;
        }
        ASTNode controlFlowKeyword = object;
        ASTNode aSTNode = ASTNodeExtensionKt.prevLeaf$default($this$isOnSameLineAsControlFlowKeyword, false, 1, null);
        if (aSTNode == null) {
            return false;
        }
        ASTNode prevLeaf2 = aSTNode;
        while (!Intrinsics.areEqual((Object)prevLeaf2, (Object)controlFlowKeyword)) {
            if (ASTNodeExtensionKt.isWhiteSpaceWithNewline(prevLeaf2)) {
                return false;
            }
            if (ASTNodeExtensionKt.prevLeaf$default(prevLeaf2, false, 1, null) != null) continue;
            return false;
        }
        return true;
    }
}

