/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.core.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ec4j.core.model.Adaptable;
import org.ec4j.core.model.Ec4jPath;
import org.ec4j.core.model.EditorConfig;
import org.ec4j.core.model.Glob;
import org.ec4j.core.model.Property;
import org.ec4j.core.model.PropertyType;
import org.ec4j.core.model.Version;

public class Section
extends Adaptable {
    private final Glob glob;
    private final Map<String, Property> properties;

    public static Builder builder() {
        return new Builder(null);
    }

    Section(List<Object> adapters, Glob glob, Map<String, Property> properties) {
        super(adapters);
        this.glob = glob;
        this.properties = properties;
    }

    public void appendTo(StringBuilder s) {
        if (!this.glob.isEmpty()) {
            s.append('[');
            s.append(this.glob.toString());
            s.append("]\n");
        }
        int i = 0;
        for (Property property : this.properties.values()) {
            if (i > 0) {
                s.append("\n");
            }
            s.append(property.toString());
            ++i;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Section other = (Section)obj;
        if (this.glob == null ? other.glob != null : !this.glob.equals(other.glob)) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public Glob getGlob() {
        return this.glob;
    }

    public Map<String, Property> getProperties() {
        return this.properties;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.glob == null ? 0 : this.glob.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean match(Ec4jPath filePath) {
        return this.glob == null ? true : this.glob.match(filePath);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        this.appendTo(s);
        return s.toString();
    }

    public static class Builder
    extends Adaptable.Builder<Builder> {
        private Glob glob;
        private boolean parentAware = false;
        final EditorConfig.Builder parentBuilder;
        private Map<String, Property.Builder> properties = new LinkedHashMap<String, Property.Builder>();

        public Builder(EditorConfig.Builder parentBuilder) {
            this.parentBuilder = parentBuilder;
        }

        public Builder applyDefaults() {
            String value;
            PropertyType<Integer> type;
            Version version = this.parentBuilder.version;
            Property.Builder indentStyle = this.properties.get(PropertyType.indent_style.getName());
            Property.Builder indentSize = this.properties.get(PropertyType.indent_size.getName());
            Property.Builder tabWidth = this.properties.get(PropertyType.tab_width.getName());
            if (indentStyle != null && PropertyType.IndentStyleValue.tab.name().equals(indentStyle.value.getSource()) && indentSize == null && version.compareTo(Version._0_10_0) >= 0) {
                type = PropertyType.indent_size;
                value = "tab";
                indentSize = this.openProperty().type(type).value(type.parse("tab"));
                this.property(indentSize);
            }
            if (indentSize != null && !"tab".equals(indentSize.value.getSource()) && tabWidth == null) {
                type = PropertyType.tab_width;
                value = indentSize.value.getSource();
                tabWidth = this.openProperty().type(type).value(type.parse(value));
                this.property(tabWidth);
            }
            if (indentSize != null && "tab".equals(indentSize.value.getSource()) && tabWidth != null) {
                type = PropertyType.indent_size;
                value = tabWidth.value.getSource();
                indentSize = this.openProperty().type(type).value(type.parse(value));
                this.property(indentSize);
            }
            return this;
        }

        public Section build() {
            LinkedHashMap<String, Property> useProps = new LinkedHashMap<String, Property>(this.properties.size());
            ArrayList<List> propAdapters = new ArrayList<List>();
            for (Property.Builder propBuilder : this.properties.values()) {
                if (this.parentAware) {
                    propAdapters.add(propBuilder.adapters);
                }
                Property prop = propBuilder.build();
                useProps.put(prop.getName(), prop);
            }
            this.properties = null;
            Section result = new Section(this.sealAdapters(), this.glob, Collections.unmodifiableMap(useProps));
            for (List adapters : propAdapters) {
                adapters.add(result);
            }
            return result;
        }

        public EditorConfig.Builder closeSection() {
            if (this.glob == null) {
                Property.Builder rootProp = this.properties.remove(PropertyType.root.getName());
                if (rootProp != null) {
                    this.parentBuilder.root(rootProp.value.getSource().equalsIgnoreCase(Boolean.TRUE.toString()));
                }
            } else {
                this.parentBuilder.section(this);
            }
            return this.parentBuilder;
        }

        public Builder glob(Glob glob) {
            this.glob = glob;
            return this;
        }

        public Property.Builder openProperty() {
            return new Property.Builder(this);
        }

        public Builder parentAware(boolean parentAware) {
            this.parentAware = parentAware;
            return this;
        }

        public Builder properties(Collection<Property.Builder> properties) {
            for (Property.Builder property : properties) {
                this.properties.put(property.name, property);
            }
            return this;
        }

        public Builder properties(Property.Builder ... properties) {
            for (Property.Builder property : properties) {
                this.properties.put(property.name, property);
            }
            return this;
        }

        public Builder property(Property.Builder property) {
            this.properties.put(property.name, property);
            return this;
        }
    }
}

