/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard.rules;

import com.pinterest.ktlint.rule.engine.core.api.ASTNodeExtensionKt;
import com.pinterest.ktlint.rule.engine.core.api.ElementType;
import com.pinterest.ktlint.ruleset.standard.StandardRule;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002Je\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2K\u0010\t\u001aG\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00040\nH\u0016J\u0014\u0010\u0012\u001a\u00020\u0004*\u00020\u00062\u0006\u0010\u0013\u001a\u00020\bH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/rules/SpacingAroundDoubleColonRule;", "Lcom/pinterest/ktlint/ruleset/standard/StandardRule;", "()V", "beforeVisitChildNodes", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "removeSelf", "removeSingleWhiteSpace", "ktlint-ruleset-standard"})
public final class SpacingAroundDoubleColonRule
extends StandardRule {
    public SpacingAroundDoubleColonRule() {
        super("double-colon-spacing", null, null, 6, null);
    }

    @Override
    public void beforeVisitChildNodes(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getCOLONCOLON())) {
            boolean bl;
            ASTNode prevLeaf2 = ASTNodeExtensionKt.prevLeaf$default(node, false, 1, null);
            ASTNode nextLeaf2 = ASTNodeExtensionKt.nextLeaf$default(node, false, false, 3, null);
            boolean removeSingleWhiteSpace = false;
            if (ASTNodeExtensionKt.isPartOf(node, ElementType.INSTANCE.getCLASS_LITERAL_EXPRESSION()) && prevLeaf2 instanceof PsiWhiteSpace) {
                bl = true;
            } else if (ASTNodeExtensionKt.isPartOf(node, ElementType.INSTANCE.getCALLABLE_REFERENCE_EXPRESSION()) && prevLeaf2 instanceof PsiWhiteSpace) {
                if (node.getTreePrev() == null) {
                    removeSingleWhiteSpace = true;
                    bl = !prevLeaf2.textContains('\n') && prevLeaf2.getPsi().getTextLength() > 1;
                } else {
                    bl = !prevLeaf2.textContains('\n');
                }
            } else {
                bl = false;
            }
            boolean spacingBefore = bl;
            boolean spacingAfter = nextLeaf2 instanceof PsiWhiteSpace;
            if (spacingBefore && spacingAfter) {
                emit.invoke((Object)node.getStartOffset(), (Object)("Unexpected spacing around \"" + node.getText() + '\"'), (Object)true);
                if (autoCorrect) {
                    ASTNode aSTNode = prevLeaf2;
                    Intrinsics.checkNotNull((Object)aSTNode);
                    this.removeSelf(aSTNode, removeSingleWhiteSpace);
                    ASTNode aSTNode2 = nextLeaf2;
                    Intrinsics.checkNotNull((Object)aSTNode2);
                    aSTNode2.getTreeParent().removeChild(nextLeaf2);
                }
            } else if (spacingBefore) {
                ASTNode aSTNode = prevLeaf2;
                Intrinsics.checkNotNull((Object)aSTNode);
                emit.invoke((Object)aSTNode.getStartOffset(), (Object)("Unexpected spacing before \"" + node.getText() + '\"'), (Object)true);
                if (autoCorrect) {
                    this.removeSelf(prevLeaf2, removeSingleWhiteSpace);
                }
            } else if (spacingAfter) {
                ASTNode aSTNode = nextLeaf2;
                Intrinsics.checkNotNull((Object)aSTNode);
                emit.invoke((Object)aSTNode.getStartOffset(), (Object)("Unexpected spacing after \"" + node.getText() + '\"'), (Object)true);
                if (autoCorrect) {
                    nextLeaf2.getTreeParent().removeChild(nextLeaf2);
                }
            }
        }
    }

    private final void removeSelf(ASTNode $this$removeSelf, boolean removeSingleWhiteSpace) {
        if (removeSingleWhiteSpace) {
            Intrinsics.checkNotNull((Object)$this$removeSelf, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
            LeafPsiElement leafPsiElement = (LeafPsiElement)$this$removeSelf;
            String string = ((LeafPsiElement)$this$removeSelf).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
            String string2 = string;
            int n = 0;
            int n2 = ((LeafPsiElement)$this$removeSelf).getTextLength() - 1;
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            leafPsiElement.rawReplaceWithText(string3);
        } else {
            $this$removeSelf.getTreeParent().removeChild($this$removeSelf);
        }
    }
}

